/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.BinaryEntry;

public class BinaryHashMap {
    private static final long NULL_PTR = -1L;
    private static final int PTR_SIZE = 8;
    private static final int SLOT_SIZE = 2;
    private static final int ENTRY_HEADER_SIZE = 12;
    private final IBinaryHashFunction putHashFunc;
    private final IBinaryHashFunction getHashFunc;
    private final IBinaryComparator cmp;
    private final BinaryEntry returnValue = new BinaryEntry();
    private final long[] listHeads;
    private final int frameSize;
    private final List<ByteBuffer> frames = new ArrayList<ByteBuffer>();
    private int currFrameIndex;
    private int nextOff;
    private int size;

    public BinaryHashMap(int tableSize, int frameSize, IBinaryHashFunction putHashFunc, IBinaryHashFunction getHashFunc, IBinaryComparator cmp) {
        this.listHeads = new long[tableSize];
        this.frameSize = frameSize;
        this.putHashFunc = putHashFunc;
        this.getHashFunc = getHashFunc;
        this.cmp = cmp;
        this.frames.add(ByteBuffer.allocate(frameSize));
        this.clear();
    }

    public BinaryEntry put(BinaryEntry key, BinaryEntry value) throws HyracksDataException {
        return this.getPutInternal(key, value, true);
    }

    public BinaryEntry get(BinaryEntry key) throws HyracksDataException {
        return this.getPutInternal(key, null, false);
    }

    private BinaryEntry getPutInternal(BinaryEntry key, BinaryEntry value, boolean put) throws HyracksDataException {
        int frameOff;
        ByteBuffer frame;
        int bucket = put ? Math.abs(this.putHashFunc.hash(key.getBuf(), key.getOffset(), key.getLength()) % this.listHeads.length) : Math.abs(this.getHashFunc.hash(key.getBuf(), key.getOffset(), key.getLength()) % this.listHeads.length);
        long headPtr = this.listHeads[bucket];
        if (headPtr == -1L) {
            if (put) {
                this.listHeads[bucket] = this.appendEntry(key, value);
            }
            return null;
        }
        do {
            int frameIndex = this.getFrameIndex(headPtr);
            frameOff = this.getFrameOffset(headPtr);
            frame = this.frames.get(frameIndex);
            int entryKeyOff = frameOff + 12;
            short entryKeyLen = frame.getShort(frameOff);
            if (this.cmp.compare(frame.array(), entryKeyOff, (int)entryKeyLen, key.getBuf(), key.getOffset(), key.getLength()) != 0) continue;
            int entryValOff = frameOff + 12 + entryKeyLen;
            short entryValLen = frame.getShort(frameOff + 2);
            this.returnValue.set(frame.array(), entryValOff, (int)entryValLen);
            return this.returnValue;
        } while ((headPtr = frame.getLong(frameOff + 4)) != -1L);
        if (put) {
            long newPtr = this.appendEntry(key, value);
            frame.putLong(frameOff + 4, newPtr);
        }
        return null;
    }

    public long appendEntry(BinaryEntry key, BinaryEntry value) {
        ByteBuffer frame = this.frames.get(this.currFrameIndex);
        int requiredSpace = key.getLength() + value.getLength() + 12;
        if (this.nextOff + requiredSpace >= this.frameSize) {
            if (requiredSpace > this.frameSize) {
                throw new IllegalStateException("Key and value greater than framesize.");
            }
            this.frames.add(ByteBuffer.allocate(this.frameSize));
            ++this.currFrameIndex;
            this.nextOff = 0;
            frame = this.frames.get(this.currFrameIndex);
        }
        this.writeEntryHeader(frame, this.nextOff, key.getLength(), value.getLength(), -1L);
        System.arraycopy(key.getBuf(), key.getOffset(), frame.array(), this.nextOff + 12, key.getLength());
        System.arraycopy(value.getBuf(), value.getOffset(), frame.array(), this.nextOff + 12 + key.getLength(), value.getLength());
        long entryPtr = this.getEntryPtr(this.currFrameIndex, this.nextOff);
        this.nextOff += requiredSpace;
        ++this.size;
        return entryPtr;
    }

    private void writeEntryHeader(ByteBuffer frame, int targetOff, int keyLen, int valLen, long ptr) {
        frame.putShort(targetOff, (short)keyLen);
        frame.putShort(targetOff + 2, (short)valLen);
        frame.putLong(targetOff + 4, ptr);
    }

    private long getEntryPtr(int frameIndex, int frameOff) {
        return ((long)frameIndex << 32) + (long)frameOff;
    }

    private int getFrameIndex(long ptr) {
        return (int)(ptr >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    private int getFrameOffset(long ptr) {
        return (int)(ptr & 0xFFFFFFFFFFFFFFFFL);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size > 0;
    }

    public void clear() {
        Arrays.fill(this.listHeads, -1L);
        this.currFrameIndex = 0;
        this.nextOff = 0;
        this.size = 0;
    }

    public Iterator<Pair<BinaryEntry, BinaryEntry>> iterator() {
        return new BinaryHashMapIterator();
    }

    public class BinaryHashMapIterator
    implements Iterator<Pair<BinaryEntry, BinaryEntry>> {
        private final Pair<BinaryEntry, BinaryEntry> val = new Pair((Object)new BinaryEntry(), (Object)new BinaryEntry());
        private int listHeadIndex = 0;
        private ByteBuffer frame = null;
        private int frameIndex = -1;
        private int frameOff = -1;

        @Override
        public boolean hasNext() {
            if (this.frame != null) {
                long nextPtr = this.frame.getLong(this.frameOff + 4);
                if (nextPtr == -1L) {
                    ++this.listHeadIndex;
                    return this.nextListHead();
                }
                this.setValue(nextPtr);
                return true;
            }
            return this.nextListHead();
        }

        private boolean nextListHead() {
            while (this.listHeadIndex < BinaryHashMap.this.listHeads.length && BinaryHashMap.this.listHeads[this.listHeadIndex] == -1L) {
                ++this.listHeadIndex;
            }
            if (this.listHeadIndex < BinaryHashMap.this.listHeads.length) {
                this.setValue(BinaryHashMap.this.listHeads[this.listHeadIndex]);
                return true;
            }
            this.frame = null;
            return false;
        }

        private void setValue(long ptr) {
            this.frameIndex = BinaryHashMap.this.getFrameIndex(ptr);
            this.frameOff = BinaryHashMap.this.getFrameOffset(ptr);
            this.frame = BinaryHashMap.this.frames.get(this.frameIndex);
            int entryKeyOff = this.frameOff + 12;
            short entryKeyLen = this.frame.getShort(this.frameOff);
            int entryValOff = this.frameOff + 12 + entryKeyLen;
            short entryValLen = this.frame.getShort(this.frameOff + 2);
            ((BinaryEntry)this.val.first).set(this.frame.array(), entryKeyOff, (int)entryKeyLen);
            ((BinaryEntry)this.val.second).set(this.frame.array(), entryValOff, (int)entryValLen);
        }

        @Override
        public Pair<BinaryEntry, BinaryEntry> next() {
            return this.val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not implemented");
        }
    }
}

