/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.ISlotManager;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.rtree.api.IRTreeFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreePolicy;
import org.apache.hyracks.storage.am.rtree.frames.RTreeComputationUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMInteriorFrame;
import org.apache.hyracks.storage.am.rtree.impls.EntriesOrder;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSplitKey;
import org.apache.hyracks.storage.am.rtree.impls.Rectangle;
import org.apache.hyracks.storage.am.rtree.impls.TupleEntryArrayList;
import org.apache.hyracks.storage.am.rtree.impls.UnorderedSlotManager;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;
import org.apache.hyracks.storage.common.MultiComparator;

public class RStarTreePolicy
implements IRTreePolicy {
    private TupleEntryArrayList tupleEntries1;
    private TupleEntryArrayList tupleEntries2;
    private Rectangle[] rec;
    private static final int nearMinimumOverlapFactor = 32;
    private static final double splitFactor = 0.4;
    private static final int numTuplesEntries = 100;
    private final ITreeIndexTupleWriter tupleWriter;
    private final IPrimitiveValueProvider[] keyValueProviders;
    private ITreeIndexTupleReference cmpFrameTuple;
    private final int totalFreeSpaceOff;

    public RStarTreePolicy(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, ITreeIndexTupleReference cmpFrameTuple, int totalFreeSpaceOff) {
        this.tupleWriter = tupleWriter;
        this.keyValueProviders = keyValueProviders;
        this.totalFreeSpaceOff = totalFreeSpaceOff;
        this.cmpFrameTuple = cmpFrameTuple;
        this.tupleEntries1 = new TupleEntryArrayList(100, 100);
        this.tupleEntries2 = new TupleEntryArrayList(100, 100);
        this.rec = new Rectangle[4];
        for (int i = 0; i < 4; ++i) {
            this.rec[i] = new Rectangle(keyValueProviders.length / 2);
        }
    }

    @Override
    public void split(ITreeIndexFrame leftFrame, ByteBuffer buf, ITreeIndexFrame rightFrame, ISlotManager slotManager, ITreeIndexTupleReference frameTuple, ITupleReference tuple, ISplitKey splitKey) throws HyracksDataException {
        int endIndex;
        int startIndex;
        int i;
        RTreeSplitKey rTreeSplitKey = (RTreeSplitKey)splitKey;
        RTreeTypeAwareTupleWriter rTreeTupleWriterleftRTreeFrame = (RTreeTypeAwareTupleWriter)this.tupleWriter;
        RTreeTypeAwareTupleWriter rTreeTupleWriterRightFrame = (RTreeTypeAwareTupleWriter)rightFrame.getTupleWriter();
        RTreeNSMFrame leftRTreeFrame = (RTreeNSMFrame)leftFrame;
        int m = (int)Math.floor((double)(leftRTreeFrame.getTupleCount() + 1) * 0.4);
        int splitDistribution = leftRTreeFrame.getTupleCount() - 2 * m + 2;
        double minMargin = Double.MAX_VALUE;
        int splitAxis = 0;
        int sortOrder = 0;
        int maxFieldPos = this.keyValueProviders.length / 2;
        for (i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            for (int k = 0; k < leftRTreeFrame.getTupleCount(); ++k) {
                frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, k);
                double LowerKey = this.keyValueProviders[i].getValue(frameTuple.getFieldData(i), frameTuple.getFieldStart(i));
                double UpperKey = this.keyValueProviders[j].getValue(frameTuple.getFieldData(j), frameTuple.getFieldStart(j));
                this.tupleEntries1.add(k, LowerKey);
                this.tupleEntries2.add(k, UpperKey);
            }
            double LowerKey = this.keyValueProviders[i].getValue(tuple.getFieldData(i), tuple.getFieldStart(i));
            double UpperKey = this.keyValueProviders[j].getValue(tuple.getFieldData(j), tuple.getFieldStart(j));
            this.tupleEntries1.add(-1, LowerKey);
            this.tupleEntries2.add(-1, UpperKey);
            this.tupleEntries1.sort(EntriesOrder.ASCENDING, leftRTreeFrame.getTupleCount() + 1);
            this.tupleEntries2.sort(EntriesOrder.ASCENDING, leftRTreeFrame.getTupleCount() + 1);
            double lowerMargin = 0.0;
            double upperMargin = 0.0;
            for (int k = 1; k <= splitDistribution; ++k) {
                int d = m - 1 + k;
                this.generateDist(leftRTreeFrame, frameTuple, tuple, this.tupleEntries1, this.rec[0], 0, d);
                this.generateDist(leftRTreeFrame, frameTuple, tuple, this.tupleEntries2, this.rec[1], 0, d);
                this.generateDist(leftRTreeFrame, frameTuple, tuple, this.tupleEntries1, this.rec[2], d, leftRTreeFrame.getTupleCount() + 1);
                this.generateDist(leftRTreeFrame, frameTuple, tuple, this.tupleEntries2, this.rec[3], d, leftRTreeFrame.getTupleCount() + 1);
                lowerMargin += this.rec[0].margin() + this.rec[2].margin();
                upperMargin += this.rec[1].margin() + this.rec[3].margin();
            }
            double margin = Math.min(lowerMargin, upperMargin);
            if (margin < minMargin) {
                minMargin = margin;
                splitAxis = i;
                sortOrder = lowerMargin < upperMargin ? 0 : 2;
            }
            this.tupleEntries1.clear();
            this.tupleEntries2.clear();
        }
        for (i = 0; i < leftRTreeFrame.getTupleCount(); ++i) {
            frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, i);
            double key = this.keyValueProviders[splitAxis + sortOrder].getValue(frameTuple.getFieldData(splitAxis + sortOrder), frameTuple.getFieldStart(splitAxis + sortOrder));
            this.tupleEntries1.add(i, key);
        }
        double key = this.keyValueProviders[splitAxis + sortOrder].getValue(tuple.getFieldData(splitAxis + sortOrder), tuple.getFieldStart(splitAxis + sortOrder));
        this.tupleEntries1.add(-1, key);
        this.tupleEntries1.sort(EntriesOrder.ASCENDING, leftRTreeFrame.getTupleCount() + 1);
        double minArea = Double.MAX_VALUE;
        double minOverlap = Double.MAX_VALUE;
        int splitPoint = 0;
        for (int i2 = 1; i2 <= splitDistribution; ++i2) {
            double area;
            int d = m - 1 + i2;
            this.generateDist(leftRTreeFrame, frameTuple, tuple, this.tupleEntries1, this.rec[0], 0, d);
            this.generateDist(leftRTreeFrame, frameTuple, tuple, this.tupleEntries1, this.rec[2], d, leftRTreeFrame.getTupleCount() + 1);
            double overlap = this.rec[0].overlappedArea(this.rec[2]);
            if (overlap < minOverlap) {
                splitPoint = d;
                minOverlap = overlap;
                minArea = this.rec[0].area() + this.rec[2].area();
                continue;
            }
            if (overlap != minOverlap || !((area = this.rec[0].area() + this.rec[2].area()) < minArea)) continue;
            splitPoint = d;
            minArea = area;
        }
        if (splitPoint < (leftRTreeFrame.getTupleCount() + 1) / 2) {
            startIndex = 0;
            endIndex = splitPoint;
        } else {
            startIndex = splitPoint;
            endIndex = leftRTreeFrame.getTupleCount() + 1;
        }
        boolean insertedNewTupleInRightFrame = false;
        int totalBytes = 0;
        int numOfDeletedTuples = 0;
        for (int i3 = startIndex; i3 < endIndex; ++i3) {
            if (this.tupleEntries1.get(i3).getTupleIndex() != -1) {
                frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, this.tupleEntries1.get(i3).getTupleIndex());
                rightFrame.insert((ITupleReference)frameTuple, -1);
                ((UnorderedSlotManager)slotManager).modifySlot(slotManager.getSlotOff(this.tupleEntries1.get(i3).getTupleIndex()), -1);
                totalBytes += leftRTreeFrame.getTupleSize((ITupleReference)frameTuple);
                ++numOfDeletedTuples;
                continue;
            }
            insertedNewTupleInRightFrame = true;
        }
        ((UnorderedSlotManager)slotManager).deleteEmptySlots();
        buf.putInt(this.totalFreeSpaceOff, buf.getInt(this.totalFreeSpaceOff) + totalBytes + slotManager.getSlotSize() * numOfDeletedTuples);
        rightFrame.compact();
        leftRTreeFrame.compact();
        if (insertedNewTupleInRightFrame) {
            if (rightFrame.hasSpaceInsert(tuple) == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE) {
                rightFrame.insert(tuple, -1);
            } else {
                leftRTreeFrame.insert(tuple, -1);
            }
        } else if (leftRTreeFrame.hasSpaceInsert(tuple) == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE) {
            leftRTreeFrame.insert(tuple, -1);
        } else {
            rightFrame.insert(tuple, -1);
        }
        int tupleOff = slotManager.getTupleOff(slotManager.getSlotEndOff());
        frameTuple.resetByTupleOffset(buf.array(), tupleOff);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)frameTuple, 0, this.keyValueProviders.length);
        splitKey.initData(splitKeySize);
        leftRTreeFrame.adjustMBR();
        rTreeTupleWriterleftRTreeFrame.writeTupleFields(leftRTreeFrame.getMBRTuples(), 0, rTreeSplitKey.getLeftPageBuffer(), 0);
        rTreeSplitKey.getLeftTuple().resetByTupleOffset(rTreeSplitKey.getLeftPageBuffer().array(), 0);
        ((IRTreeFrame)rightFrame).adjustMBR();
        rTreeTupleWriterRightFrame.writeTupleFields(((RTreeNSMFrame)rightFrame).getMBRTuples(), 0, rTreeSplitKey.getRightPageBuffer(), 0);
        rTreeSplitKey.getRightTuple().resetByTupleOffset(rTreeSplitKey.getRightPageBuffer().array(), 0);
        this.tupleEntries1.clear();
        this.tupleEntries2.clear();
    }

    public void generateDist(ITreeIndexFrame leftRTreeFrame, ITreeIndexTupleReference frameTuple, ITupleReference tuple, TupleEntryArrayList entries, Rectangle rec, int start, int end) {
        int j = 0;
        while (entries.get(j).getTupleIndex() == -1) {
            ++j;
        }
        frameTuple.resetByTupleIndex(leftRTreeFrame, entries.get(j).getTupleIndex());
        rec.set((ITupleReference)frameTuple, this.keyValueProviders);
        for (int i = start; i < end; ++i) {
            if (i == j) continue;
            if (entries.get(i).getTupleIndex() != -1) {
                frameTuple.resetByTupleIndex(leftRTreeFrame, entries.get(i).getTupleIndex());
                rec.enlarge((ITupleReference)frameTuple, this.keyValueProviders);
                continue;
            }
            rec.enlarge(tuple, this.keyValueProviders);
        }
    }

    @Override
    public int findBestChildPosition(ITreeIndexFrame frame, ITupleReference tuple, ITreeIndexTupleReference frameTuple, MultiComparator cmp) throws HyracksDataException {
        this.cmpFrameTuple.setFieldCount(cmp.getKeyFieldCount());
        frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int bestChild = 0;
        double minEnlargedArea = Double.MAX_VALUE;
        if (frame.getLevel() == 1) {
            for (int i = 0; i < frame.getTupleCount(); ++i) {
                frameTuple.resetByTupleIndex(frame, i);
                double enlargedArea = RTreeComputationUtils.enlargedArea((ITupleReference)frameTuple, tuple, cmp, this.keyValueProviders);
                this.tupleEntries1.add(i, enlargedArea);
                if (!(enlargedArea < minEnlargedArea)) continue;
                minEnlargedArea = enlargedArea;
                bestChild = i;
            }
            if (minEnlargedArea < RTreeNSMFrame.doubleEpsilon() || minEnlargedArea > RTreeNSMFrame.doubleEpsilon()) {
                int k;
                minEnlargedArea = Double.MAX_VALUE;
                if (frame.getTupleCount() > 32) {
                    this.tupleEntries1.sort(EntriesOrder.ASCENDING, frame.getTupleCount());
                    k = 32;
                } else {
                    k = frame.getTupleCount();
                }
                double minOverlap = Double.MAX_VALUE;
                int id = 0;
                for (int i = 0; i < k; ++i) {
                    double difference = 0.0;
                    for (int j = 0; j < frame.getTupleCount(); ++j) {
                        frameTuple.resetByTupleIndex(frame, j);
                        this.cmpFrameTuple.resetByTupleIndex(frame, this.tupleEntries1.get(i).getTupleIndex());
                        int c = ((RTreeNSMInteriorFrame)frame).pointerCmp((ITupleReference)frameTuple, (ITupleReference)this.cmpFrameTuple, cmp);
                        if (c != 0) {
                            double intersection = RTreeComputationUtils.overlappedArea((ITupleReference)frameTuple, tuple, (ITupleReference)this.cmpFrameTuple, cmp, this.keyValueProviders);
                            if (intersection == 0.0) continue;
                            difference += intersection - RTreeComputationUtils.overlappedArea((ITupleReference)frameTuple, null, (ITupleReference)this.cmpFrameTuple, cmp, this.keyValueProviders);
                            continue;
                        }
                        id = j;
                    }
                    double enlargedArea = RTreeComputationUtils.enlargedArea((ITupleReference)this.cmpFrameTuple, tuple, cmp, this.keyValueProviders);
                    if (difference < minOverlap) {
                        minOverlap = difference;
                        minEnlargedArea = enlargedArea;
                        bestChild = id;
                        continue;
                    }
                    if (difference != minOverlap) continue;
                    if (enlargedArea < minEnlargedArea) {
                        minEnlargedArea = enlargedArea;
                        bestChild = id;
                        continue;
                    }
                    if (enlargedArea != minEnlargedArea) continue;
                    double area = RTreeComputationUtils.area((ITupleReference)this.cmpFrameTuple, cmp, this.keyValueProviders);
                    frameTuple.resetByTupleIndex(frame, bestChild);
                    double minArea = RTreeComputationUtils.area((ITupleReference)frameTuple, cmp, this.keyValueProviders);
                    if (!(area < minArea)) continue;
                    bestChild = id;
                }
            }
        } else {
            for (int i = 0; i < frame.getTupleCount(); ++i) {
                frameTuple.resetByTupleIndex(frame, i);
                double enlargedArea = RTreeComputationUtils.enlargedArea((ITupleReference)frameTuple, tuple, cmp, this.keyValueProviders);
                if (enlargedArea < minEnlargedArea) {
                    minEnlargedArea = enlargedArea;
                    bestChild = i;
                    continue;
                }
                if (enlargedArea != minEnlargedArea) continue;
                double area = RTreeComputationUtils.area((ITupleReference)frameTuple, cmp, this.keyValueProviders);
                frameTuple.resetByTupleIndex(frame, bestChild);
                double minArea = RTreeComputationUtils.area((ITupleReference)frameTuple, cmp, this.keyValueProviders);
                if (!(area < minArea)) continue;
                bestChild = i;
            }
        }
        this.tupleEntries1.clear();
        return bestChild;
    }
}

