/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.QueryServiceRequestParameters;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ExecutionError;
import org.apache.asterix.app.result.ExecutionWarning;
import org.apache.asterix.app.result.ResponseMetrics;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.result.fields.ClientContextIdPrinter;
import org.apache.asterix.app.result.fields.ErrorsPrinter;
import org.apache.asterix.app.result.fields.MetricsPrinter;
import org.apache.asterix.app.result.fields.ParseOnlyResultPrinter;
import org.apache.asterix.app.result.fields.PlansPrinter;
import org.apache.asterix.app.result.fields.ProfilePrinter;
import org.apache.asterix.app.result.fields.RequestIdPrinter;
import org.apache.asterix.app.result.fields.SignaturePrinter;
import org.apache.asterix.app.result.fields.StatusPrinter;
import org.apache.asterix.app.result.fields.TypePrinter;
import org.apache.asterix.app.result.fields.WarningsPrinter;
import org.apache.asterix.app.translator.QueryTranslator;
import org.apache.asterix.app.translator.RequestParameters;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.ICodedMessage;
import org.apache.asterix.common.api.IReceptionist;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.sqlpp.parser.TokenMgrError;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryServiceServlet
extends AbstractQueryApiServlet {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final ILangExtension.Language queryLanguage;
    private final ILangCompilationProvider compilationProvider;
    private final IStatementExecutorFactory statementExecutorFactory;
    private final IStorageComponentProvider componentProvider;
    private final IReceptionist receptionist;
    protected final IServiceContext serviceCtx;
    protected final Function<IServletRequest, Map<String, String>> optionalParamProvider;
    protected String hostName;

    public QueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, ILangExtension.Language queryLanguage, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider, Function<IServletRequest, Map<String, String>> optionalParamProvider) {
        super(appCtx, ctx, paths);
        this.queryLanguage = queryLanguage;
        this.compilationProvider = compilationProvider;
        this.statementExecutorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
        this.receptionist = appCtx.getReceptionist();
        this.serviceCtx = (IServiceContext)ctx.get("org.apache.asterix.SERVICE_CONTEXT");
        this.optionalParamProvider = optionalParamProvider;
        try {
            this.hostName = InetAddress.getByName(this.serviceCtx.getAppConfig().getString((IOption)CCConfig.Option.CLUSTER_PUBLIC_ADDRESS)).getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Reverse DNS not properly configured, CORS defaulting to localhost", (Throwable)e);
            this.hostName = "localhost";
        }
    }

    protected final void get(IServletRequest request, IServletResponse response) throws IOException {
        this.handleRequest(request, response, true);
    }

    protected final void post(IServletRequest request, IServletResponse response) throws IOException {
        this.handleRequest(request, response, false);
    }

    protected void options(IServletRequest request, IServletResponse response) throws Exception {
        if (request.getHeader((CharSequence)"Origin") != null) {
            response.setHeader((CharSequence)"Access-Control-Allow-Origin", (Object)request.getHeader((CharSequence)"Origin"));
        }
        response.setHeader((CharSequence)"Access-Control-Allow-Headers", (Object)"Origin, X-Requested-With, Content-Type, Accept");
        response.setStatus(HttpResponseStatus.OK);
    }

    private static SessionOutput createSessionOutput(PrintWriter resultWriter) {
        SessionOutput.ResultDecorator resultPrefix = ResultUtil.createPreResultDecorator();
        SessionOutput.ResultDecorator resultPostfix = ResultUtil.createPostResultDecorator();
        SessionOutput.ResultAppender appendStatus = ResultUtil.createResultStatusAppender();
        SessionConfig sessionConfig = new SessionConfig(SessionConfig.OutputFormat.CLEAN_JSON);
        return new SessionOutput(sessionConfig, resultWriter, resultPrefix, resultPostfix, null, appendStatus);
    }

    protected void setRequestParam(IServletRequest request, QueryServiceRequestParameters param, Function<IServletRequest, Map<String, String>> optionalParamProvider, RequestExecutionState executionState) throws IOException, AlgebricksException {
        Map<String, String> optionalParams = null;
        if (optionalParamProvider != null) {
            optionalParams = optionalParamProvider.apply(request);
        }
        param.setParameters(this, request, optionalParams);
    }

    private void setAccessControlHeaders(IServletRequest request, IServletResponse response) throws IOException {
        if (request.getHeader((CharSequence)"Origin") != null) {
            response.setHeader((CharSequence)"Access-Control-Allow-Origin", (Object)request.getHeader((CharSequence)"Origin"));
        }
        response.setHeader((CharSequence)"Access-Control-Allow-Headers", (Object)"Origin, X-Requested-With, Content-Type, Accept");
    }

    private static String handlePath(IStatementExecutor.ResultDelivery delivery) {
        switch (delivery) {
            case ASYNC: {
                return "/status/";
            }
            case DEFERRED: {
                return "/result/";
            }
        }
        return "";
    }

    protected String getHandleUrl(String host, String path, IStatementExecutor.ResultDelivery delivery) {
        return "http://" + host + path + QueryServiceServlet.handlePath(delivery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(IServletRequest request, IServletResponse response, boolean forceReadOnly) throws IOException {
        IRequestReference requestRef = this.receptionist.welcome(request);
        long elapsedStart = System.nanoTime();
        long errorCount = 1L;
        IStatementExecutor.Stats stats = new IStatementExecutor.Stats();
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        Charset resultCharset = HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        PrintWriter httpWriter = response.writer();
        SessionOutput sessionOutput = QueryServiceServlet.createSessionOutput(httpWriter);
        ResponsePrinter responsePrinter = new ResponsePrinter(sessionOutput);
        IStatementExecutor.ResultDelivery delivery = IStatementExecutor.ResultDelivery.IMMEDIATE;
        QueryServiceRequestParameters param = this.newQueryRequestParameters();
        RequestExecutionState executionState = this.newRequestExecutionState();
        try {
            responsePrinter.begin();
            this.setRequestParam(request, param, this.optionalParamProvider, executionState);
            if (forceReadOnly) {
                param.setReadOnly(true);
            }
            LOGGER.info(() -> "handleRequest: " + LogRedactionUtil.statement((String)param.toString()));
            delivery = param.getMode();
            this.setSessionConfig(sessionOutput, param, delivery);
            ResultProperties resultProperties = new ResultProperties(delivery, param.getMaxResultReads());
            this.buildResponseHeaders(requestRef, sessionOutput, param, responsePrinter, delivery);
            responsePrinter.printHeaders();
            String statement = param.getStatement();
            statement = statement == null || !statement.isEmpty() && statement.charAt(statement.length() - 1) == ';' ? statement : statement + ";";
            this.validateStatement(statement);
            if (param.isParseOnly()) {
                ResultUtil.ParseOnlyResult parseOnlyResult = this.parseStatement(statement);
                this.setAccessControlHeaders(request, response);
                executionState.setStatus(AbstractQueryApiServlet.ResultStatus.SUCCESS, HttpResponseStatus.OK);
                response.setStatus(executionState.getHttpStatus());
                responsePrinter.addResultPrinter(new ParseOnlyResultPrinter(parseOnlyResult));
            } else {
                Map<String, byte[]> statementParams = RequestParameters.serializeParameterValues(param.getStatementParams());
                this.setAccessControlHeaders(request, response);
                stats.setProfileType(param.getProfileType());
                IStatementExecutor.StatementProperties statementProperties = new IStatementExecutor.StatementProperties();
                response.setStatus(HttpResponseStatus.OK);
                this.executeStatement(request, requestRef, statement, sessionOutput, resultProperties, statementProperties, stats, param, executionState, param.getOptionalParams(), statementParams, responsePrinter, warnings);
                executionState.setStatus(AbstractQueryApiServlet.ResultStatus.SUCCESS, HttpResponseStatus.OK);
            }
            errorCount = 0L;
        }
        catch (Exception | TokenMgrError e) {
            this.handleExecuteStatementException(e, executionState, param);
            response.setStatus(executionState.getHttpStatus());
            this.requestFailed(e, responsePrinter);
        }
        finally {
            executionState.finish();
        }
        responsePrinter.printResults();
        this.buildResponseFooters(elapsedStart, errorCount, stats, executionState, resultCharset, responsePrinter, delivery);
        responsePrinter.printFooters();
        responsePrinter.end();
        if (sessionOutput.out().checkError()) {
            LOGGER.warn("Error flushing output writer");
        }
    }

    protected RequestExecutionState newRequestExecutionState() throws HyracksDataException {
        return new RequestExecutionState();
    }

    protected void buildResponseHeaders(IRequestReference requestRef, SessionOutput sessionOutput, QueryServiceRequestParameters param, ResponsePrinter responsePrinter, IStatementExecutor.ResultDelivery delivery) {
        responsePrinter.addHeaderPrinter(new RequestIdPrinter(requestRef.getUuid()));
        if (param.getClientContextID() != null && !param.getClientContextID().isEmpty()) {
            responsePrinter.addHeaderPrinter(new ClientContextIdPrinter(param.getClientContextID()));
        }
        if (param.isSignature() && delivery != IStatementExecutor.ResultDelivery.ASYNC && !param.isParseOnly()) {
            responsePrinter.addHeaderPrinter(SignaturePrinter.INSTANCE);
        }
        if (sessionOutput.config().fmt() == SessionConfig.OutputFormat.ADM || sessionOutput.config().fmt() == SessionConfig.OutputFormat.CSV) {
            responsePrinter.addHeaderPrinter(new TypePrinter(sessionOutput.config()));
        }
    }

    protected void buildResponseResults(ResponsePrinter responsePrinter, SessionOutput sessionOutput, ExecutionPlans plans, List<Warning> warnings) throws HyracksDataException {
        responsePrinter.addResultPrinter(new PlansPrinter(plans, sessionOutput.config().getPlanFormat()));
        if (!warnings.isEmpty()) {
            ArrayList<ICodedMessage> codedWarnings = new ArrayList<ICodedMessage>();
            warnings.forEach(warn -> codedWarnings.add(ExecutionWarning.of(warn)));
            responsePrinter.addResultPrinter(new WarningsPrinter(codedWarnings));
        }
    }

    protected ResponseMetrics buildResponseFooters(long elapsedStart, long errorCount, IStatementExecutor.Stats stats, RequestExecutionState executionState, Charset resultCharset, ResponsePrinter responsePrinter, IStatementExecutor.ResultDelivery delivery) {
        if (IStatementExecutor.ResultDelivery.ASYNC != delivery) {
            responsePrinter.addFooterPrinter(new StatusPrinter(executionState.getResultStatus()));
        }
        ResponseMetrics metrics = ResponseMetrics.of(System.nanoTime() - elapsedStart, executionState.duration(), stats.getCount(), stats.getSize(), stats.getProcessedObjects(), errorCount, stats.getTotalWarningsCount());
        responsePrinter.addFooterPrinter(new MetricsPrinter(metrics, resultCharset));
        if (QueryServiceServlet.isPrintingProfile(stats)) {
            responsePrinter.addFooterPrinter(new ProfilePrinter(stats.getJobProfile()));
        }
        return metrics;
    }

    protected void validateStatement(String statement) throws RuntimeDataException {
        if (statement == null || statement.isEmpty()) {
            throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.NO_STATEMENT_PROVIDED, new Serializable[0]);
        }
    }

    protected ResultUtil.ParseOnlyResult parseStatement(String statementsText) throws CompilationException {
        IParserFactory factory = this.compilationProvider.getParserFactory();
        IParser parser = factory.createParser(statementsText);
        List stmts = parser.parse();
        QueryTranslator.validateStatements(stmts, true, 0);
        Query query = (Query)stmts.get(stmts.size() - 1);
        Set extVars = this.compilationProvider.getRewriterFactory().createQueryRewriter().getExternalVariables(query.getBody());
        return new ResultUtil.ParseOnlyResult(extVars);
    }

    protected void executeStatement(IServletRequest request, IRequestReference requestReference, String statementsText, SessionOutput sessionOutput, ResultProperties resultProperties, IStatementExecutor.StatementProperties statementProperties, IStatementExecutor.Stats stats, QueryServiceRequestParameters param, RequestExecutionState executionState, Map<String, String> optionalParameters, Map<String, byte[]> statementParameters, ResponsePrinter responsePrinter, List<Warning> warnings) throws Exception {
        IClusterManagementWork.ClusterState clusterState = ((ICcApplicationContext)this.appCtx).getClusterStateManager().getState();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            throw new IllegalStateException("Cannot execute request, cluster is " + clusterState);
        }
        IParser parser = this.compilationProvider.getParserFactory().createParser(statementsText);
        List statements = parser.parse();
        long maxWarnings = sessionOutput.config().getMaxWarnings();
        parser.getWarnings(warnings, maxWarnings);
        long parserTotalWarningsCount = parser.getTotalWarningsCount();
        MetadataManager.INSTANCE.init();
        IStatementExecutor translator = this.statementExecutorFactory.create((ICcApplicationContext)this.appCtx, statements, sessionOutput, this.compilationProvider, this.componentProvider, (IResponsePrinter)responsePrinter);
        executionState.start();
        Map<String, IAObject> stmtParams = RequestParameters.deserializeParameterValues(statementParameters);
        int stmtCategoryRestriction = RequestParameters.getStatementCategoryRestrictionMask(param.isReadOnly());
        IRequestParameters requestParameters = this.newRequestParameters(param, requestReference, statementsText, this.getResultSet(), resultProperties, stats, statementProperties, optionalParameters, stmtParams, stmtCategoryRestriction);
        translator.compileAndExecute(this.getHyracksClientConnection(), requestParameters);
        executionState.end();
        translator.getWarnings(warnings, maxWarnings - (long)warnings.size());
        stats.updateTotalWarningsCount(parserTotalWarningsCount);
        this.buildResponseResults(responsePrinter, sessionOutput, translator.getExecutionPlans(), warnings);
    }

    protected boolean handleIFormattedException(IError error, IFormattedException ex, RequestExecutionState executionState, QueryServiceRequestParameters param) {
        if (error instanceof org.apache.asterix.common.exceptions.ErrorCode) {
            switch ((org.apache.asterix.common.exceptions.ErrorCode)error) {
                case INVALID_REQ_PARAM_VAL: 
                case INVALID_REQ_JSON_VAL: 
                case NO_STATEMENT_PROVIDED: {
                    executionState.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.BAD_REQUEST);
                    return true;
                }
                case REQUEST_TIMEOUT: {
                    LOGGER.info(() -> "handleException: request execution timed out: " + LogRedactionUtil.userData((String)param.toString()));
                    executionState.setStatus(AbstractQueryApiServlet.ResultStatus.TIMEOUT, HttpResponseStatus.OK);
                    return true;
                }
                case REJECT_NODE_UNREGISTERED: 
                case REJECT_BAD_CLUSTER_STATE: {
                    LOGGER.warn(() -> "handleException: " + ex.getMessage() + ": " + LogRedactionUtil.userData((String)param.toString()));
                    executionState.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.SERVICE_UNAVAILABLE);
                }
            }
        } else if (error instanceof ErrorCode) {
            switch ((ErrorCode)error) {
                case JOB_REQUIREMENTS_EXCEED_CAPACITY: {
                    executionState.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.BAD_REQUEST);
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleExecuteStatementException(Throwable t, RequestExecutionState executionState, QueryServiceRequestParameters param) {
        IFormattedException formattedEx;
        Optional maybeError;
        if (t instanceof TokenMgrError || t instanceof AlgebricksException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("handleException: {}: {}", (Object)t.getMessage(), (Object)LogRedactionUtil.statement((String)param.toString()), (Object)t);
            } else {
                LOGGER.info(() -> "handleException: " + t.getMessage() + ": " + LogRedactionUtil.statement((String)param.toString()));
            }
            executionState.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (t instanceof IFormattedException && (maybeError = (formattedEx = (IFormattedException)t).getError()).isPresent() && this.handleIFormattedException((IError)maybeError.get(), (IFormattedException)t, executionState, param)) {
            return;
        }
        LOGGER.warn(() -> "handleException: unexpected exception: " + LogRedactionUtil.userData((String)param.toString()), t);
        executionState.setStatus(AbstractQueryApiServlet.ResultStatus.FATAL, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private void setSessionConfig(SessionOutput sessionOutput, QueryServiceRequestParameters param, IStatementExecutor.ResultDelivery delivery) {
        String handleUrl = this.getHandleUrl(param.getHost(), param.getPath(), delivery);
        sessionOutput.setHandleAppender(ResultUtil.createResultHandleAppender(handleUrl));
        SessionConfig sessionConfig = sessionOutput.config();
        SessionConfig.OutputFormat format = param.getFormat();
        SessionConfig.PlanFormat planFormat = param.getPlanFormat();
        sessionConfig.setFmt(format);
        sessionConfig.setPlanFormat(planFormat);
        sessionConfig.setMaxWarnings(param.getMaxWarnings());
        sessionConfig.set("format-wrapper-array", true);
        sessionConfig.set("oob-expr-tree", param.isExpressionTree());
        sessionConfig.set("oob-rewritten-expr-tree", param.isRewrittenExpressionTree());
        sessionConfig.set("oob-logical-plan", param.isLogicalPlan());
        sessionConfig.set("oob-optimized-logical-plan", param.isOptimizedLogicalPlan());
        sessionConfig.set("oob-hyracks-job", param.isJob());
        sessionConfig.set("indent-json", param.isPretty());
        sessionConfig.set("quote-record", format != SessionConfig.OutputFormat.CLEAN_JSON && format != SessionConfig.OutputFormat.LOSSLESS_JSON);
        sessionConfig.set("format-csv-header", param.isCSVWithHeader());
    }

    protected void requestFailed(Throwable throwable, ResponsePrinter responsePrinter) {
        ExecutionError executionError = ExecutionError.of(throwable);
        responsePrinter.addResultPrinter(new ErrorsPrinter(Collections.singletonList(executionError)));
    }

    protected QueryServiceRequestParameters newQueryRequestParameters() {
        return new QueryServiceRequestParameters();
    }

    protected IRequestParameters newRequestParameters(QueryServiceRequestParameters param, IRequestReference requestReference, String statementsText, IResultSet resultSet, ResultProperties resultProperties, IStatementExecutor.Stats stats, IStatementExecutor.StatementProperties statementProperties, Map<String, String> optionalParameters, Map<String, IAObject> stmtParams, int stmtCategoryRestriction) {
        return new RequestParameters(requestReference, statementsText, resultSet, resultProperties, stats, statementProperties, null, param.getClientContextID(), optionalParameters, stmtParams, param.isMultiStatement(), stmtCategoryRestriction);
    }

    protected static boolean isPrintingProfile(IStatementExecutor.Stats stats) {
        return stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL && stats.getJobProfile() != null;
    }

    protected static class RequestExecutionState {
        private long execStart = -1L;
        private long execEnd = -1L;
        private AbstractQueryApiServlet.ResultStatus resultStatus = AbstractQueryApiServlet.ResultStatus.FATAL;
        private HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;

        protected RequestExecutionState() {
        }

        public void setStatus(AbstractQueryApiServlet.ResultStatus resultStatus, HttpResponseStatus httpResponseStatus) {
            this.resultStatus = resultStatus;
            this.httpResponseStatus = httpResponseStatus;
        }

        public AbstractQueryApiServlet.ResultStatus getResultStatus() {
            return this.resultStatus;
        }

        HttpResponseStatus getHttpStatus() {
            return this.httpResponseStatus;
        }

        void start() {
            this.execStart = System.nanoTime();
        }

        void end() {
            this.execEnd = System.nanoTime();
        }

        void finish() {
            if (this.execStart == -1L) {
                this.execEnd = -1L;
            } else if (this.execEnd == -1L) {
                this.execEnd = System.nanoTime();
            }
        }

        public long duration() {
            return this.execEnd - this.execStart;
        }

        protected StringBuilder append(StringBuilder sb) {
            return sb.append("ResultStatus: ").append(this.resultStatus.str()).append(" HTTPStatus: ").append(String.valueOf(this.httpResponseStatus));
        }

        public String toString() {
            return this.append(new StringBuilder()).toString();
        }
    }
}

