/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.file;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.common.buffercache.AbstractBufferedFileIOManager;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.BufferCacheHeaderHelper;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.compression.file.CompressedFileReference;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.compression.file.NoOpLAFWriter;
import org.apache.hyracks.storage.common.file.CompressedBufferedFileHandle;

public class BufferedFileHandle
extends AbstractBufferedFileIOManager {
    private final int fileId;
    private final AtomicInteger refCount;

    protected BufferedFileHandle(int fileId, BufferCache bufferCache, IIOManager ioManager, BlockingQueue<BufferCacheHeaderHelper> headerPageCache, IPageReplacementStrategy pageReplacementStrategy) {
        super(bufferCache, ioManager, headerPageCache, pageReplacementStrategy);
        this.fileId = fileId;
        this.refCount = new AtomicInteger();
    }

    public int getFileId() {
        return this.fileId;
    }

    public int incReferenceCount() {
        return this.refCount.incrementAndGet();
    }

    public int decReferenceCount() {
        return this.refCount.decrementAndGet();
    }

    public int getReferenceCount() {
        return this.refCount.get();
    }

    public long getDiskPageId(int pageId) {
        return BufferedFileHandle.getDiskPageId(this.fileId, pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(CachedPage cPage) throws HyracksDataException {
        BufferCacheHeaderHelper header = this.checkoutHeaderHelper();
        try {
            long bytesRead = this.readToBuffer(header.prepareRead(this.bufferCache.getPageSizeWithHeader()), this.getFirstPageOffset(cPage));
            if (!this.verifyBytesRead(this.bufferCache.getPageSizeWithHeader(), bytesRead)) {
                return;
            }
            ByteBuffer buf = header.processHeader(cPage);
            cPage.getBuffer().put(buf);
        }
        finally {
            this.returnHeaderHelper(header);
        }
        this.readExtraPages(cPage);
    }

    private void readExtraPages(CachedPage cPage) throws HyracksDataException {
        int totalPages = cPage.getFrameSizeMultiplier();
        if (totalPages > 1) {
            this.pageReplacementStrategy.fixupCapacityOnLargeRead(cPage);
            cPage.getBuffer().position(this.bufferCache.getPageSize());
            cPage.getBuffer().limit(totalPages * this.bufferCache.getPageSize());
            this.readToBuffer(cPage.getBuffer(), this.getExtraPageOffset(cPage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(CachedPage cPage, BufferCacheHeaderHelper header, int totalPages, int extraBlockPageId) throws HyracksDataException {
        long bytesWritten;
        ByteBuffer buf = cPage.getBuffer();
        boolean contiguousLargePages = BufferedFileHandle.getPageId(cPage.getDiskPageId()) + 1 == extraBlockPageId;
        try {
            buf.limit(contiguousLargePages ? this.bufferCache.getPageSize() * totalPages : this.bufferCache.getPageSize());
            buf.position(0);
            bytesWritten = this.writeToFile(header.prepareWrite(cPage), this.getFirstPageOffset(cPage));
        }
        finally {
            this.returnHeaderHelper(header);
        }
        if (totalPages > 1 && !contiguousLargePages) {
            buf.limit(totalPages * this.bufferCache.getPageSize());
            bytesWritten += this.writeToFile(buf, this.getExtraPageOffset(cPage));
        }
        int expectedWritten = this.bufferCache.getPageSizeWithHeader() + this.bufferCache.getPageSize() * (totalPages - 1);
        this.verifyBytesWritten(expectedWritten, bytesWritten);
    }

    @Override
    public int getNumberOfPages() {
        return (int)(this.getFileSize() / (long)this.bufferCache.getPageSizeWithHeader());
    }

    @Override
    public ICompressedPageWriter getCompressedPageWriter() {
        return NoOpLAFWriter.INSTACNE;
    }

    @Override
    protected long getFirstPageOffset(CachedPage cPage) {
        return this.getPageOffset(BufferedFileHandle.getPageId(cPage.getDiskPageId()));
    }

    @Override
    protected long getExtraPageOffset(CachedPage cPage) {
        return this.getPageOffset(cPage.getExtraBlockPageId());
    }

    private long getPageOffset(long pageId) {
        return pageId * (long)this.bufferCache.getPageSizeWithHeader();
    }

    public static long getDiskPageId(int fileId, int pageId) {
        return ((long)fileId << 32) + (long)pageId;
    }

    public static int getFileId(long dpid) {
        return (int)(dpid >> 32);
    }

    public static int getPageId(long dpid) {
        return (int)dpid;
    }

    public static BufferedFileHandle create(FileReference fileRef, int fileId, BufferCache bufferCache, IIOManager ioManager, BlockingQueue<BufferCacheHeaderHelper> headerPageCache, IPageReplacementStrategy pageReplacementStrategy) {
        if (fileRef.isCompressed()) {
            CompressedFileReference cFileRef = (CompressedFileReference)fileRef;
            return new CompressedBufferedFileHandle(fileId, cFileRef.getLAFFileReference(), bufferCache, ioManager, headerPageCache, pageReplacementStrategy);
        }
        return new BufferedFileHandle(fileId, bufferCache, ioManager, headerPageCache, pageReplacementStrategy);
    }
}

