/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceProjectsRule
implements IAlgebraicRewriteRule {
    private final Set<LogicalVariable> usedVars = new LinkedHashSet<LogicalVariable>();
    private final Set<LogicalVariable> liveVars = new LinkedHashSet<LogicalVariable>();
    private final Set<LogicalVariable> producedVars = new LinkedHashSet<LogicalVariable>();
    private final List<LogicalVariable> projectVars = new ArrayList<LogicalVariable>();
    protected boolean hasRun = false;
    private final Map<AbstractLogicalOperator, Set<LogicalVariable>> allUsedVarsAfterOpMap = new HashMap<AbstractLogicalOperator, Set<LogicalVariable>>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        this.hasRun = true;
        LinkedHashSet<LogicalVariable> parentUsedVars = new LinkedHashSet<LogicalVariable>();
        this.collectUsedVars(opRef, parentUsedVars);
        return this.introduceProjects(null, -1, opRef, Collections.emptySet(), context);
    }

    protected void collectUsedVars(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> parentUsedVars) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        LinkedHashSet<LogicalVariable> usedVarsPerOp = new LinkedHashSet<LogicalVariable>();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVarsPerOp);
        usedVarsPerOp.addAll(parentUsedVars);
        if (this.allUsedVarsAfterOpMap.get(op) == null) {
            this.allUsedVarsAfterOpMap.put(op, usedVarsPerOp);
        } else {
            this.allUsedVarsAfterOpMap.get(op).addAll(usedVarsPerOp);
        }
        for (Mutable inputOpRef : op.getInputs()) {
            this.collectUsedVars((Mutable<ILogicalOperator>)inputOpRef, usedVarsPerOp);
        }
    }

    protected boolean introduceProjects(AbstractLogicalOperator parentOp, int parentInputIndex, Mutable<ILogicalOperator> opRef, Set<LogicalVariable> parentUsedVars, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean modified = false;
        this.usedVars.clear();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, this.usedVars);
        LinkedHashSet<LogicalVariable> parentsUsedVars = new LinkedHashSet<LogicalVariable>();
        parentsUsedVars.addAll(parentUsedVars);
        parentsUsedVars.addAll(this.usedVars);
        if (this.allUsedVarsAfterOpMap.get(op) != null) {
            parentsUsedVars.addAll((Collection)this.allUsedVarsAfterOpMap.get(op));
        }
        for (int i = 0; i < op.getInputs().size(); ++i) {
            Mutable inputOpRef = (Mutable)op.getInputs().get(i);
            if (!this.introduceProjects(op, i, (Mutable<ILogicalOperator>)inputOpRef, parentsUsedVars, context)) continue;
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        this.liveVars.clear();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, this.liveVars);
        this.producedVars.clear();
        VariableUtilities.getProducedVariables((ILogicalOperator)op, this.producedVars);
        this.liveVars.removeAll(this.producedVars);
        this.projectVars.clear();
        for (LogicalVariable liveVar : this.liveVars) {
            if (!parentsUsedVars.contains(liveVar)) continue;
            this.projectVars.add(liveVar);
        }
        if (this.projectVars.size() != this.liveVars.size()) {
            for (int i = 0; i < op.getInputs().size(); ++i) {
                ILogicalOperator childOp = (ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                this.liveVars.clear();
                VariableUtilities.getLiveVariables((ILogicalOperator)childOp, this.liveVars);
                ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
                vars.addAll(this.projectVars);
                vars.retainAll(this.liveVars);
                if (vars.size() == this.liveVars.size()) continue;
                ProjectOperator projectOp = new ProjectOperator(vars);
                projectOp.getInputs().add(new MutableObject((Object)childOp));
                ((Mutable)op.getInputs().get(i)).setValue((Object)projectOp);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)projectOp);
                projectOp.recomputeSchema();
                modified = true;
            }
        } else if (op.getOperatorTag() == LogicalOperatorTag.PROJECT) {
            this.liveVars.clear();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()), this.liveVars);
            ProjectOperator projectOp = (ProjectOperator)op;
            List projectVarsTemp = projectOp.getVariables();
            if (this.liveVars.size() == projectVarsTemp.size() && this.liveVars.containsAll(projectVarsTemp)) {
                ((Mutable)parentOp.getInputs().get(parentInputIndex)).setValue((Object)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()));
                modified = true;
            }
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            op.recomputeSchema();
        }
        return modified;
    }
}

