/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.utils;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.DefaultNodeGroupDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class LogicalOperatorDotVisitor
implements ILogicalOperatorVisitor<String, Boolean> {
    private final StringBuilder stringBuilder = new StringBuilder();

    public String toString() {
        return "";
    }

    private CharSequence str(Object o) {
        return String.valueOf(o);
    }

    @Override
    public String visitAggregateOperator(AggregateOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("aggregate ").append(this.str(op.getVariables())).append(" <- ");
        this.printExprList(op.getExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitRunningAggregateOperator(RunningAggregateOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("running-aggregate ").append(this.str(op.getVariables())).append(" <- ");
        this.printExprList(op.getExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("empty-tuple-source");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitGroupByOperator(GroupByOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("group by").append(op.isGroupAll() ? " (all)" : "").append(" (");
        this.printVariableAndExprList(op.getGroupByList());
        this.stringBuilder.append(") decor (");
        this.printVariableAndExprList(op.getDecorList());
        this.stringBuilder.append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDistinctOperator(DistinctOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("distinct (");
        this.printExprList(op.getExpressions());
        this.stringBuilder.append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitInnerJoinOperator(InnerJoinOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("join (").append(((ILogicalExpression)op.getCondition().getValue()).toString()).append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("left outer join (").append(((ILogicalExpression)op.getCondition().getValue()).toString()).append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("nested tuple source");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitOrderOperator(OrderOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("order ");
        int topK = op.getTopK();
        if (topK != -1) {
            this.stringBuilder.append("(topK: ").append(topK).append(") ");
        }
        this.printOrderExprList(op.getOrderExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    private void appendOrder(OrderOperator.IOrder order) {
        switch (order.getKind()) {
            case ASC: {
                this.stringBuilder.append("ASC");
                break;
            }
            case DESC: {
                this.stringBuilder.append("DESC");
                break;
            }
            default: {
                Mutable<ILogicalExpression> expressionRef = order.getExpressionRef();
                this.stringBuilder.append(expressionRef == null ? "null" : expressionRef.toString());
            }
        }
    }

    @Override
    public String visitAssignOperator(AssignOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("assign ").append(this.str(op.getVariables())).append(" <- ");
        this.printExprList(op.getExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitWriteOperator(WriteOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("write ");
        this.printExprList(op.getExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDistributeResultOperator(DistributeResultOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("distribute result ");
        this.printExprList(op.getExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitWriteResultOperator(WriteResultOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("load ").append(this.str(op.getDataSource())).append(" from ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).toString()).append(" partitioned by ");
        this.printExprList(op.getKeyExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSelectOperator(SelectOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("select (").append(((ILogicalExpression)op.getCondition().getValue()).toString()).append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitProjectOperator(ProjectOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("project ").append("(").append(op.getVariables()).append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSubplanOperator(SubplanOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("subplan {}");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitUnionOperator(UnionAllOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("union");
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> v : op.getVariableMappings()) {
            this.stringBuilder.append(" (").append(v.first).append(", ").append(v.second).append(", ").append(v.third).append(")");
        }
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitIntersectOperator(IntersectOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("intersect (");
        this.pprintVarList(op.getOutputCompareVariables());
        if (op.hasExtraVariables()) {
            this.stringBuilder.append(" extra ");
            this.pprintVarList(op.getOutputExtraVariables());
        }
        this.stringBuilder.append(" <- [");
        int n = op.getNumInput();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            this.pprintVarList(op.getInputCompareVariables(i));
            if (!op.hasExtraVariables()) continue;
            this.stringBuilder.append(" extra ");
            this.pprintVarList(op.getInputExtraVariables(i));
        }
        this.stringBuilder.append("])");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitUnnestOperator(UnnestOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("unnest ").append(op.getVariable());
        if (op.getPositionalVariable() != null) {
            this.stringBuilder.append(" at ").append(op.getPositionalVariable());
        }
        this.stringBuilder.append(" <- ").append(((ILogicalExpression)op.getExpressionRef().getValue()).toString());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("outer-unnest ").append(op.getVariable());
        if (op.getPositionalVariable() != null) {
            this.stringBuilder.append(" at ").append(op.getPositionalVariable());
        }
        this.stringBuilder.append(" <- ").append(((ILogicalExpression)op.getExpressionRef().getValue()).toString());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitUnnestMapOperator(UnnestMapOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.printAbstractUnnestMapOperator(op, "unnest-map", showDetails);
        this.appendSelectConditionInformation(op.getSelectCondition());
        this.appendLimitInformation(op.getOutputLimit());
        return this.stringBuilder.toString();
    }

    @Override
    public String visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.printAbstractUnnestMapOperator(op, "left-outer-unnest-map", showDetails);
        return this.stringBuilder.toString();
    }

    private void printAbstractUnnestMapOperator(AbstractUnnestMapOperator op, String opSignature, boolean show) {
        this.stringBuilder.append(opSignature).append(" ").append(op.getVariables()).append(" <- ").append(((ILogicalExpression)op.getExpressionRef().getValue()).toString());
        this.appendFilterInformation(op.getMinFilterVars(), op.getMaxFilterVars());
        this.appendSchema(op, show);
        this.appendAnnotations(op, show);
        this.appendPhysicalOperatorInfo(op, show);
    }

    @Override
    public String visitDataScanOperator(DataSourceScanOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("data-scan ").append(op.getProjectVariables()).append("<-").append(op.getVariables()).append(" <- ").append(op.getDataSource());
        this.appendFilterInformation(op.getMinFilterVars(), op.getMaxFilterVars());
        this.appendSelectConditionInformation(op.getSelectCondition());
        this.appendLimitInformation(op.getOutputLimit());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    private void appendFilterInformation(List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars) {
        if (minFilterVars != null || maxFilterVars != null) {
            this.stringBuilder.append(" with filter on");
        }
        if (minFilterVars != null) {
            this.stringBuilder.append(" min:").append(minFilterVars);
        }
        if (maxFilterVars != null) {
            this.stringBuilder.append(" max:").append(maxFilterVars);
        }
    }

    private void appendSelectConditionInformation(Mutable<ILogicalExpression> condition) throws AlgebricksException {
        if (condition != null) {
            this.stringBuilder.append(" condition:").append(((ILogicalExpression)condition.getValue()).toString());
        }
    }

    private void appendLimitInformation(long outputLimit) throws AlgebricksException {
        if (outputLimit >= 0L) {
            this.stringBuilder.append(" limit:").append(String.valueOf(outputLimit));
        }
    }

    @Override
    public String visitLimitOperator(LimitOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("limit");
        if (op.hasMaxObjects()) {
            this.stringBuilder.append(' ').append(op.getMaxObjects().getValue());
        }
        if (op.hasOffset()) {
            this.stringBuilder.append(" offset ").append(op.getOffset().getValue());
        }
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitExchangeOperator(ExchangeOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("exchange");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitScriptOperator(ScriptOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("script (in: ").append(op.getInputVariables()).append(") (out: ").append(op.getOutputVariables()).append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitReplicateOperator(ReplicateOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("replicate");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSplitOperator(SplitOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        Mutable<ILogicalExpression> branchingExpression = op.getBranchingExpression();
        this.stringBuilder.append("split ").append(((ILogicalExpression)branchingExpression.getValue()).toString());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitMaterializeOperator(MaterializeOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("materialize");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        String header = this.getIndexOpString(op.getOperation());
        this.stringBuilder.append(header).append(this.str(op.getDataSource())).append(" from record: ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).toString());
        if (op.getAdditionalNonFilteringExpressions() != null) {
            this.stringBuilder.append(", meta: ");
            this.printExprList(op.getAdditionalNonFilteringExpressions());
        }
        this.stringBuilder.append(" partitioned by ");
        this.printExprList(op.getPrimaryKeyExpressions());
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.stringBuilder.append(" out: ([record-before-upsert:").append(op.getBeforeOpRecordVar());
            if (op.getBeforeOpAdditionalNonFilteringVars() != null) {
                this.stringBuilder.append(", additional-before-upsert: ").append(op.getBeforeOpAdditionalNonFilteringVars());
            }
            this.stringBuilder.append("]) ");
        }
        if (op.isBulkload()) {
            this.stringBuilder.append(" [bulkload]");
        }
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        String header = this.getIndexOpString(op.getOperation());
        this.stringBuilder.append(header).append(op.getIndexName()).append(" on ").append(this.str(op.getDataSourceIndex().getDataSource())).append(" from ");
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.stringBuilder.append(" replace:");
            this.printExprList(op.getPrevSecondaryKeyExprs());
            this.stringBuilder.append(" with:");
            this.printExprList(op.getSecondaryKeyExpressions());
        }
        if (!op.getNestedPlans().isEmpty()) {
            this.stringBuilder.append("{ a nested plan }");
        } else {
            this.printExprList(op.getSecondaryKeyExpressions());
        }
        if (op.isBulkload()) {
            this.stringBuilder.append(" [bulkload]");
        }
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    private String getIndexOpString(InsertDeleteUpsertOperator.Kind opKind) {
        switch (opKind) {
            case DELETE: {
                return "delete from ";
            }
            case INSERT: {
                return "insert into ";
            }
            case UPSERT: {
                return "upsert into ";
            }
        }
        return "";
    }

    @Override
    public String visitTokenizeOperator(TokenizeOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("tokenize ").append(this.str(op.getTokenizeVars())).append(" <- ");
        this.printExprList(op.getSecondaryKeyExpressions());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitSinkOperator(SinkOperator op, Boolean showDetails) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("sink");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitDelegateOperator(DelegateOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(op.toString());
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitForwardOperator(ForwardOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("forward(").append(((ILogicalExpression)op.getSideDataExpression().getValue()).toString()).append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    @Override
    public String visitWindowOperator(WindowOperator op, Boolean showDetails) throws AlgebricksException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("window (").append(this.str(op.getVariables())).append(" <- ");
        this.printExprList(op.getExpressions());
        this.stringBuilder.append(") partition by (");
        this.printExprList(op.getPartitionExpressions());
        this.stringBuilder.append(") order by (");
        this.printOrderExprList(op.getOrderExpressions());
        if (op.hasNestedPlans()) {
            int frameMaxObjects;
            Mutable<ILogicalExpression> frameOffsetExpression;
            Mutable<ILogicalExpression> frameExcludeUnaryExpression;
            List<Mutable<ILogicalExpression>> frameExcludeExpressions;
            List<Mutable<ILogicalExpression>> frameEndValidationExpressions;
            List<Mutable<ILogicalExpression>> frameEndExpressions;
            List<Mutable<ILogicalExpression>> frameStartValidationExpressions;
            this.stringBuilder.append(") frame on (");
            this.printOrderExprList(op.getFrameValueExpressions());
            List<Mutable<ILogicalExpression>> frameStartExpressions = op.getFrameStartExpressions();
            if (!frameStartExpressions.isEmpty()) {
                this.stringBuilder.append(") frame start (");
                this.printExprList(frameStartExpressions);
            }
            if (!(frameStartValidationExpressions = op.getFrameStartValidationExpressions()).isEmpty()) {
                this.stringBuilder.append(") if (");
                this.printExprList(frameStartValidationExpressions);
            }
            if (!(frameEndExpressions = op.getFrameEndExpressions()).isEmpty()) {
                this.stringBuilder.append(") frame end (");
                this.printExprList(frameEndExpressions);
            }
            if (!(frameEndValidationExpressions = op.getFrameEndValidationExpressions()).isEmpty()) {
                this.stringBuilder.append(") if (");
                this.printExprList(frameEndValidationExpressions);
            }
            if (!(frameExcludeExpressions = op.getFrameExcludeExpressions()).isEmpty()) {
                this.stringBuilder.append(") frame exclude (");
                this.stringBuilder.append(" (negation start: ").append(op.getFrameExcludeNegationStartIdx()).append(") ");
                this.printExprList(frameExcludeExpressions);
            }
            if ((frameExcludeUnaryExpression = op.getFrameExcludeUnaryExpression()).getValue() != null) {
                this.stringBuilder.append(") frame exclude unary (");
                this.stringBuilder.append(frameExcludeUnaryExpression.getValue());
                this.stringBuilder.append(") ");
            }
            if ((frameOffsetExpression = op.getFrameOffsetExpression()).getValue() != null) {
                this.stringBuilder.append(") frame offset (");
                this.stringBuilder.append(frameOffsetExpression.getValue());
                this.stringBuilder.append(") ");
            }
            if ((frameMaxObjects = op.getFrameMaxObjects()) != -1) {
                this.stringBuilder.append("(frame maxObjects: ").append(frameMaxObjects).append(") ");
            }
        }
        this.stringBuilder.append(")");
        this.appendSchema(op, showDetails);
        this.appendAnnotations(op, showDetails);
        this.appendPhysicalOperatorInfo(op, showDetails);
        return this.stringBuilder.toString();
    }

    protected void pprintVarList(List<LogicalVariable> variables) {
        this.stringBuilder.append("[");
        variables.forEach(var -> this.stringBuilder.append(this.str(var)).append(", "));
        this.stringBuilder.append("]");
    }

    private void printExprList(List<Mutable<ILogicalExpression>> expressions) {
        this.stringBuilder.append("[");
        expressions.forEach(exprRef -> this.stringBuilder.append(((ILogicalExpression)exprRef.getValue()).toString()).append(", "));
        this.stringBuilder.append("]");
    }

    private void printVariableAndExprList(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> variableExprList) {
        this.stringBuilder.append("[");
        boolean first = true;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> variableExpressionPair : variableExprList) {
            if (first) {
                first = false;
            } else {
                this.stringBuilder.append("; ");
            }
            if (variableExpressionPair.first != null) {
                this.stringBuilder.append(variableExpressionPair.first).append(" := ").append(variableExpressionPair.second);
                continue;
            }
            this.stringBuilder.append(((ILogicalExpression)((Mutable)variableExpressionPair.second).getValue()).toString());
        }
        this.stringBuilder.append("]");
    }

    private void printOrderExprList(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprList) {
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : orderExprList) {
            this.stringBuilder.append("(");
            this.appendOrder((OrderOperator.IOrder)p.first);
            this.stringBuilder.append(", ").append(((ILogicalExpression)((Mutable)p.second).getValue()).toString()).append(") ");
        }
    }

    private void appendSchema(AbstractLogicalOperator op, boolean show) {
        if (show) {
            this.stringBuilder.append("\\nSchema: ");
            List<LogicalVariable> schema = op.getSchema();
            this.stringBuilder.append(schema == null ? "null" : schema);
        }
    }

    private void appendAnnotations(AbstractLogicalOperator op, boolean show) {
        Map<String, Object> annotations;
        if (show && !(annotations = op.getAnnotations()).isEmpty()) {
            this.stringBuilder.append("\\nAnnotations: ").append(annotations);
        }
    }

    private void appendPhysicalOperatorInfo(AbstractLogicalOperator op, boolean show) {
        IPhysicalOperator physicalOp = op.getPhysicalOperator();
        this.stringBuilder.append("\\n").append(physicalOp == null ? "null" : physicalOp.toString().trim());
        this.stringBuilder.append(", Exec: ").append((Object)op.getExecutionMode());
        if (show) {
            IPartitioningProperty partitioningProp;
            IPhysicalPropertiesVector properties = physicalOp == null ? null : physicalOp.getDeliveredProperties();
            List<ILocalStructuralProperty> localProp = properties == null ? null : properties.getLocalProperties();
            IPartitioningProperty iPartitioningProperty = partitioningProp = properties == null ? null : properties.getPartitioningProperty();
            if (localProp != null) {
                this.stringBuilder.append("\\nProperties in each partition: [");
                for (ILocalStructuralProperty property : localProp) {
                    if (property == null) {
                        this.stringBuilder.append("null, ");
                    } else if (property.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
                        this.stringBuilder.append("ordered by ");
                    } else if (property.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_GROUPING_PROPERTY) {
                        this.stringBuilder.append("group by ");
                    }
                    this.stringBuilder.append(property).append(", ");
                }
                this.stringBuilder.append("]");
            }
            if (partitioningProp != null) {
                this.stringBuilder.append("\\n").append((Object)partitioningProp.getPartitioningType()).append(":");
                INodeDomain nodeDomain = partitioningProp.getNodeDomain();
                this.stringBuilder.append("\\n ");
                if (nodeDomain != null && nodeDomain.cardinality() != null) {
                    this.stringBuilder.append(nodeDomain.cardinality()).append(" partitions. ");
                }
                switch (partitioningProp.getPartitioningType()) {
                    case BROADCAST: {
                        this.stringBuilder.append("Data is broadcast to partitions.");
                        break;
                    }
                    case RANDOM: {
                        this.stringBuilder.append("Data is randomly partitioned.");
                        break;
                    }
                    case ORDERED_PARTITIONED: {
                        this.stringBuilder.append("Data is orderly partitioned via a range.");
                        break;
                    }
                    case UNORDERED_PARTITIONED: {
                        this.stringBuilder.append("Data is hash partitioned.");
                        break;
                    }
                    case UNPARTITIONED: {
                        this.stringBuilder.append("Data is in one place.");
                    }
                    case PARTIAL_BROADCAST_ORDERED_FOLLOWING: {
                        this.stringBuilder.append("Data is partially broadcasted to partitions.");
                        break;
                    }
                    case PARTIAL_BROADCAST_ORDERED_INTERSECT: {
                        this.stringBuilder.append("Data is partially broadcasted to partitions.");
                    }
                }
                if (nodeDomain instanceof DefaultNodeGroupDomain) {
                    DefaultNodeGroupDomain nd = (DefaultNodeGroupDomain)nodeDomain;
                    this.stringBuilder.append("\\n").append(nd);
                }
            }
        }
    }
}

