/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.security;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hyracks.api.network.INetworkSecurityConfig;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.ipc.sockets.PlainSocketChannelFactory;
import org.apache.hyracks.ipc.sockets.SslSocketChannelFactory;

public class NetworkSecurityManager
implements INetworkSecurityManager {
    private volatile INetworkSecurityConfig config;
    private final ISocketChannelFactory sslSocketFactory;
    public static final String TSL_VERSION = "TLSv1.2";

    public NetworkSecurityManager(INetworkSecurityConfig config) {
        this.config = config;
        this.sslSocketFactory = new SslSocketChannelFactory(this);
    }

    public SSLContext newSSLContext() {
        return NetworkSecurityManager.newSSLContext(this.config);
    }

    public SSLEngine newSSLEngine() {
        try {
            SSLContext ctx = this.newSSLContext();
            return ctx.createSSLEngine();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create SSLEngine", ex);
        }
    }

    public ISocketChannelFactory getSocketChannelFactory() {
        if (this.config.isSslEnabled()) {
            return this.sslSocketFactory;
        }
        return PlainSocketChannelFactory.INSTANCE;
    }

    public INetworkSecurityConfig getConfiguration() {
        return this.config;
    }

    public void setConfiguration(INetworkSecurityConfig config) {
        this.config = config;
    }

    public static SSLContext newSSLContext(INetworkSecurityConfig config) {
        try {
            char[] password = NetworkSecurityManager.getKeyStorePassword(config);
            KeyStore engineKeyStore = config.getKeyStore();
            if (engineKeyStore == null) {
                engineKeyStore = NetworkSecurityManager.loadKeyStoreFromFile(password, config);
            }
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(defaultAlgorithm);
            keyManagerFactory.init(engineKeyStore, password);
            KeyStore trustStore = NetworkSecurityManager.loadTrustStoreFromFile(password, config);
            trustManagerFactory.init(trustStore);
            SSLContext ctx = SSLContext.getInstance(TSL_VERSION);
            ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return ctx;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create SSLEngine", ex);
        }
    }

    private static KeyStore loadKeyStoreFromFile(char[] password, INetworkSecurityConfig config) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(new FileInputStream(config.getKeyStoreFile()), password);
            return ks;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load key store", e);
        }
    }

    private static KeyStore loadTrustStoreFromFile(char[] password, INetworkSecurityConfig config) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(new FileInputStream(config.getTrustStoreFile()), password);
            return ks;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load trust store", e);
        }
    }

    private static char[] getKeyStorePassword(INetworkSecurityConfig config) {
        String pass = config.getKeyStorePassword();
        return pass == null || pass.isEmpty() ? null : pass.toCharArray();
    }
}

