/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.ProgressReceiver;
import com.azure.storage.common.implementation.StorageImplUtils;

public final class ParallelTransferOptions {
    private final Integer blockSize;
    private final Integer numBuffers;
    private final ProgressReceiver progressReceiver;
    private final Integer maxSingleUploadSize;

    public ParallelTransferOptions(Integer blockSize, Integer numBuffers, ProgressReceiver progressReceiver) {
        this(blockSize, numBuffers, progressReceiver, null);
    }

    public ParallelTransferOptions(Integer blockSize, Integer numBuffers, ProgressReceiver progressReceiver, Integer maxSingleUploadSize) {
        if (blockSize != null) {
            StorageImplUtils.assertInBounds((String)"blockSize", (long)blockSize.intValue(), (long)1L, (long)0x6400000L);
        }
        this.blockSize = blockSize;
        if (numBuffers != null) {
            StorageImplUtils.assertInBounds((String)"numBuffers", (long)numBuffers.intValue(), (long)2L, (long)Integer.MAX_VALUE);
        }
        this.numBuffers = numBuffers;
        this.progressReceiver = progressReceiver;
        if (maxSingleUploadSize != null) {
            StorageImplUtils.assertInBounds((String)"maxSingleUploadSize", (long)maxSingleUploadSize.intValue(), (long)1L, (long)0x10000000L);
        }
        this.maxSingleUploadSize = maxSingleUploadSize;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getNumBuffers() {
        return this.numBuffers;
    }

    public ProgressReceiver getProgressReceiver() {
        return this.progressReceiver;
    }

    public Integer getMaxSingleUploadSize() {
        return this.maxSingleUploadSize;
    }
}

