/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Map;

public final class BlobProperties {
    private final OffsetDateTime creationTime;
    private final OffsetDateTime lastModified;
    private final String eTag;
    private final long blobSize;
    private final String contentType;
    private final byte[] contentMd5;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final String cacheControl;
    private final Long blobSequenceNumber;
    private final BlobType blobType;
    private final LeaseStatusType leaseStatus;
    private final LeaseStateType leaseState;
    private final LeaseDurationType leaseDuration;
    private final String copyId;
    private final CopyStatusType copyStatus;
    private final String copySource;
    private final String copyProgress;
    private final OffsetDateTime copyCompletionTime;
    private final String copyStatusDescription;
    private final Boolean isServerEncrypted;
    private final Boolean isIncrementalCopy;
    private final String copyDestinationSnapshot;
    private final AccessTier accessTier;
    private final Boolean isAccessTierInferred;
    private final ArchiveStatus archiveStatus;
    private final String encryptionKeySha256;
    private final OffsetDateTime accessTierChangeTime;
    private final Map<String, String> metadata;
    private final Integer committedBlockCount;

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount) {
        this.creationTime = creationTime;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.blobSize = blobSize;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.cacheControl = cacheControl;
        this.blobSequenceNumber = blobSequenceNumber;
        this.blobType = blobType;
        this.leaseStatus = leaseStatus;
        this.leaseState = leaseState;
        this.leaseDuration = leaseDuration;
        this.copyId = copyId;
        this.copyStatus = copyStatus;
        this.copySource = copySource;
        this.copyProgress = copyProgress;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.isServerEncrypted = isServerEncrypted;
        this.isIncrementalCopy = isIncrementalCopy;
        this.copyDestinationSnapshot = copyDestinationSnapshot;
        this.accessTier = accessTier;
        this.isAccessTierInferred = isAccessTierInferred;
        this.archiveStatus = archiveStatus;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.accessTierChangeTime = accessTierChangeTime;
        this.metadata = metadata;
        this.committedBlockCount = committedBlockCount;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getBlobSize() {
        return this.blobSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.copyCompletionTime;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    public String getCopyDestinationSnapshot() {
        return this.copyDestinationSnapshot;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public Boolean isAccessTierInferred() {
        return this.isAccessTierInferred;
    }

    public ArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Integer getCommittedBlockCount() {
        return this.committedBlockCount;
    }
}

