/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.fulltext;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextConfigEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextFilterEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextFilterEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;

public class FullTextConfigEvaluatorFactory
implements IFullTextConfigEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final TokenizerCategory tokenizerCategory;
    private final ImmutableList<IFullTextFilterEvaluatorFactory> filters;
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TOKENIZER_CATEGORY = "tokenizerCategory";
    private static final String FIELD_FILTERS = "filters";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public FullTextConfigEvaluatorFactory(String name, TokenizerCategory tokenizerCategory, ImmutableList<IFullTextFilterEvaluatorFactory> filters) {
        this.name = name;
        this.tokenizerCategory = tokenizerCategory;
        this.filters = filters;
    }

    @Override
    public IFullTextConfigEvaluator createFullTextConfigEvaluator() {
        ImmutableList.Builder filterEvaluatorsBuilder = ImmutableList.builder();
        for (IFullTextFilterEvaluatorFactory factory : this.filters) {
            filterEvaluatorsBuilder.add((Object)factory.createFullTextFilterEvaluator());
        }
        return new FullTextConfigEvaluator(this.name, this.tokenizerCategory, (ImmutableList<IFullTextFilterEvaluator>)filterEvaluatorsBuilder.build());
    }

    public static IFullTextConfigEvaluatorFactory getDefaultFactory() {
        return new FullTextConfigEvaluatorFactory("default_config_evaluator_factory", TokenizerCategory.WORD, (ImmutableList<IFullTextFilterEvaluatorFactory>)ImmutableList.of());
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put(FIELD_NAME, this.name);
        json.put(FIELD_TOKENIZER_CATEGORY, this.tokenizerCategory.toString());
        ArrayNode filterArray = OBJECT_MAPPER.createArrayNode();
        for (IFullTextFilterEvaluatorFactory filter : this.filters) {
            filterArray.add(filter.toJson(registry));
        }
        json.set(FIELD_FILTERS, (JsonNode)filterArray);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        String name = json.get(FIELD_NAME).asText();
        String tokenizerCategoryStr = json.get(FIELD_TOKENIZER_CATEGORY).asText();
        TokenizerCategory tc = TokenizerCategory.getEnumIgnoreCase(tokenizerCategoryStr);
        ArrayNode filtersJsonNode = (ArrayNode)json.get(FIELD_FILTERS);
        ImmutableList.Builder filtersBuilder = ImmutableList.builder();
        for (int i = 0; i < filtersJsonNode.size(); ++i) {
            filtersBuilder.add((Object)((IFullTextFilterEvaluatorFactory)registry.deserialize(filtersJsonNode.get(i))));
        }
        return new FullTextConfigEvaluatorFactory(name, tc, (ImmutableList<IFullTextFilterEvaluatorFactory>)filtersBuilder.build());
    }
}

