/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.bytes;

public class HexParser {
    private byte[] storage;
    private int length;

    public static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static int getValueFromValidHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        throw new IllegalArgumentException("Invalid hex character : " + c);
    }

    public byte[] getByteArray() {
        return this.storage;
    }

    public int getLength() {
        return this.length;
    }

    public void generateByteArrayFromHexString(char[] input, int start, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex string for binary type: the string length should be a muliple of 2.");
        }
        this.length = length / 2;
        this.ensureCapacity(this.length);
        HexParser.generateByteArrayFromHexString(input, start, length, this.storage, 0);
    }

    public void generateByteArrayFromHexString(byte[] input, int start, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex string for binary type: the string length should be a muliple of 2.");
        }
        this.length = length / 2;
        this.ensureCapacity(this.length);
        HexParser.generateByteArrayFromHexString(input, start, length, this.storage, 0);
    }

    private void ensureCapacity(int capacity) {
        if (this.storage == null || this.storage.length < capacity) {
            this.storage = new byte[capacity];
        }
    }

    public static void generateByteArrayFromHexString(char[] input, int start, int length, byte[] output, int offset) {
        for (int i = 0; i < length; i += 2) {
            output[offset + i / 2] = (byte)((HexParser.getValueFromValidHexChar(input[start + i]) << 4) + HexParser.getValueFromValidHexChar(input[start + i + 1]));
        }
    }

    public static void generateByteArrayFromHexString(byte[] input, int start, int length, byte[] output, int offset) {
        for (int i = 0; i < length; i += 2) {
            output[offset + i / 2] = (byte)((HexParser.getValueFromValidHexChar((char)input[start + i]) << 4) + HexParser.getValueFromValidHexChar((char)input[start + i + 1]));
        }
    }
}

