/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class JObject<T>
implements IJObject<T> {
    private static final Map<Class, IAType> typeConv = new ImmutableMap.Builder().put(HashMap.class, (Object)RecordUtil.FULLY_OPEN_RECORD_TYPE).put(Byte.class, (Object)BuiltinType.AINT8).put(Short.class, (Object)BuiltinType.AINT16).put(Integer.class, (Object)BuiltinType.AINT32).put(Long.class, (Object)BuiltinType.AINT64).put(Float.class, (Object)BuiltinType.AFLOAT).put(Double.class, (Object)BuiltinType.ADOUBLE).put(LocalTime.class, (Object)BuiltinType.ATIME).put(LocalDate.class, (Object)BuiltinType.ADATE).put(LocalDateTime.class, (Object)BuiltinType.ADATETIME).put(Duration.class, (Object)BuiltinType.ADURATION).put(List.class, (Object)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE).put(String.class, (Object)BuiltinType.ASTRING).put(Multiset.class, (Object)AUnorderedListType.FULLY_OPEN_UNORDEREDLIST_TYPE).build();
    protected IAObject value;
    protected byte[] bytes;
    protected IObjectPool<IJObject, Class> pool;

    protected JObject() {
    }

    public static IAType convertType(Class clazz) {
        return typeConv.get(clazz);
    }

    protected JObject(IAObject value) {
        this.value = value;
    }

    @Override
    public IAObject getIAObject() {
        return this.value;
    }

    public void serializeTypeTag(boolean writeTypeTag, DataOutput dataOutput, ATypeTag typeTag) throws HyracksDataException {
        if (writeTypeTag) {
            try {
                dataOutput.writeByte(typeTag.serialize());
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

