/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.Collection;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class CheckSubqueryVisitor
extends AbstractSqlppQueryExpressionVisitor<Boolean, ILangExpression> {
    @Override
    public Boolean visit(FromClause fromClause, ILangExpression arg) throws CompilationException {
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            if (!fromTerm.accept(this, arg).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(FromTerm fromTerm, ILangExpression arg) throws CompilationException {
        if (this.visit((ILangExpression)fromTerm.getLeftExpression(), arg)) {
            return true;
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            if (!((Boolean)correlateClause.accept(this, arg)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(JoinClause joinClause, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)joinClause.getRightExpression(), arg) || this.visit((ILangExpression)joinClause.getConditionExpression(), arg);
    }

    @Override
    public Boolean visit(NestClause nestClause, ILangExpression arg) throws CompilationException {
        return nestClause.accept(this, arg);
    }

    @Override
    public Boolean visit(Projection projection, ILangExpression arg) throws CompilationException {
        if (projection.star()) {
            return false;
        }
        return this.visit((ILangExpression)projection.getExpression(), arg);
    }

    @Override
    public Boolean visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        return this.visit(selectBlock.getFromClause(), arg) != false || this.visit(selectBlock.getGroupbyClause(), arg) != false || this.visit(selectBlock.getSelectClause(), arg) != false || this.visitExprList(selectBlock.getLetWhereList(), arg) || this.visitExprList(selectBlock.getLetHavingListAfterGroupby(), arg);
    }

    @Override
    public Boolean visit(SelectClause selectClause, ILangExpression arg) throws CompilationException {
        return this.visit(selectClause.getSelectElement(), arg) != false || this.visit(selectClause.getSelectRegular(), arg) != false;
    }

    @Override
    public Boolean visit(SelectElement selectElement, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)selectElement.getExpression(), arg);
    }

    @Override
    public Boolean visit(SelectRegular selectRegular, ILangExpression arg) throws CompilationException {
        return this.visitExprList(selectRegular.getProjections(), arg);
    }

    @Override
    public Boolean visit(SelectSetOperation selectSetOperation, ILangExpression arg) throws CompilationException {
        if (selectSetOperation.getLeftInput().accept(this, arg).booleanValue()) {
            return true;
        }
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            if (!right.getSetOperationRightInput().accept(this, arg).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(SelectExpression selectStatement, ILangExpression arg) throws CompilationException {
        if (selectStatement.isSubquery()) {
            return true;
        }
        return this.visitExprList(selectStatement.getLetList(), arg) || this.visit(selectStatement.getSelectSetOperation(), arg) != false || this.visit(selectStatement.getOrderbyClause(), arg) != false || this.visit(selectStatement.getLimitClause(), arg) != false;
    }

    @Override
    public Boolean visit(UnnestClause unnestClause, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)unnestClause.getRightExpression(), arg);
    }

    @Override
    public Boolean visit(HavingClause havingClause, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)havingClause.getFilterExpression(), arg);
    }

    @Override
    public Boolean visit(CaseExpression caseExpression, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)caseExpression.getConditionExpr(), arg) || this.visitExprList(caseExpression.getWhenExprs(), arg) || this.visitExprList(caseExpression.getThenExprs(), arg) || this.visit((ILangExpression)caseExpression.getElseExpr(), arg);
    }

    public Boolean visit(Query q, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)q.getBody(), arg);
    }

    public Boolean visit(FunctionDecl fd, ILangExpression arg) throws CompilationException {
        return (Boolean)fd.getFuncBody().accept((ILangVisitor)this, (Object)arg);
    }

    public Boolean visit(LiteralExpr l, ILangExpression arg) throws CompilationException {
        return false;
    }

    public Boolean visit(VariableExpr v, ILangExpression arg) throws CompilationException {
        return false;
    }

    public Boolean visit(ListConstructor lc, ILangExpression arg) throws CompilationException {
        return this.visitExprList(lc.getExprList(), arg);
    }

    public Boolean visit(RecordConstructor rc, ILangExpression arg) throws CompilationException {
        for (FieldBinding fb : rc.getFbList()) {
            if (this.visit((ILangExpression)fb.getLeftExpr(), arg)) {
                return true;
            }
            if (!this.visit((ILangExpression)fb.getRightExpr(), arg)) continue;
            return true;
        }
        return false;
    }

    public Boolean visit(OperatorExpr operatorExpr, ILangExpression arg) throws CompilationException {
        return this.visitExprList(operatorExpr.getExprList(), arg);
    }

    public Boolean visit(FieldAccessor fa, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)fa.getExpr(), arg);
    }

    public Boolean visit(IndexAccessor ia, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)ia.getExpr(), arg) || this.visit((ILangExpression)ia.getIndexExpr(), arg);
    }

    public Boolean visit(ListSliceExpression expression, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)expression.getExpr(), arg) || this.visit((ILangExpression)expression.getStartIndexExpression(), arg) || this.visit((ILangExpression)expression.getEndIndexExpression(), arg);
    }

    public Boolean visit(IfExpr ifexpr, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)ifexpr.getCondExpr(), arg) || this.visit((ILangExpression)ifexpr.getThenExpr(), arg) || this.visit((ILangExpression)ifexpr.getElseExpr(), arg);
    }

    public Boolean visit(QuantifiedExpression qe, ILangExpression arg) throws CompilationException {
        for (QuantifiedPair qf : qe.getQuantifiedList()) {
            if (!this.visit((ILangExpression)qf.getExpr(), arg)) continue;
            return true;
        }
        return this.visit((ILangExpression)qe.getSatisfiesExpr(), arg);
    }

    public Boolean visit(LetClause lc, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)lc.getBindingExpr(), arg);
    }

    public Boolean visit(WhereClause wc, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)wc.getWhereExpr(), arg);
    }

    public Boolean visit(OrderbyClause oc, ILangExpression arg) throws CompilationException {
        return this.visitExprList(oc.getOrderbyList(), arg);
    }

    public Boolean visit(GroupbyClause gc, ILangExpression arg) throws CompilationException {
        for (List gbyPairList : gc.getGbyPairList()) {
            for (GbyVariableExpressionPair key : gbyPairList) {
                if (!this.visit((ILangExpression)key.getExpr(), arg)) continue;
                return true;
            }
        }
        if (gc.hasDecorList()) {
            for (GbyVariableExpressionPair key : gc.getDecorPairList()) {
                if (!this.visit((ILangExpression)key.getExpr(), arg)) continue;
                return true;
            }
        }
        if (gc.hasGroupFieldList() && this.visitFieldList(gc.getGroupFieldList(), arg)) {
            return true;
        }
        if (gc.hasWithMap() && this.visitExprList(gc.getWithVarMap().keySet(), arg)) {
            return true;
        }
        return false;
    }

    public Boolean visit(LimitClause lc, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)lc.getLimitExpr(), arg) || this.visit((ILangExpression)lc.getOffset(), arg);
    }

    public Boolean visit(UnaryExpr u, ILangExpression arg) throws CompilationException {
        return this.visit((ILangExpression)u.getExpr(), arg);
    }

    @Override
    public Boolean visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        return winExpr.hasPartitionList() && this.visitExprList(winExpr.getPartitionList(), arg) || winExpr.hasOrderByList() && this.visitExprList(winExpr.getOrderbyList(), arg) || winExpr.hasFrameStartExpr() && this.visit((ILangExpression)winExpr.getFrameStartExpr(), arg) || winExpr.hasFrameEndExpr() && this.visit((ILangExpression)winExpr.getFrameEndExpr(), arg) || winExpr.hasWindowFieldList() && this.visitFieldList(winExpr.getWindowFieldList(), arg) || winExpr.hasAggregateFilterExpr() && (Boolean)winExpr.getAggregateFilterExpr().accept((ILangVisitor)this, (Object)arg) != false || this.visitExprList(winExpr.getExprList(), arg);
    }

    public Boolean visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        return this.visitExprList(callExpr.getExprList(), arg) || callExpr.hasAggregateFilterExpr() && this.visit((ILangExpression)callExpr.getAggregateFilterExpr(), arg);
    }

    private boolean visit(ILangExpression expr, ILangExpression arg) throws CompilationException {
        if (expr == null) {
            return false;
        }
        return (Boolean)expr.accept((ILangVisitor)this, (Object)arg);
    }

    private <T extends ILangExpression> boolean visitExprList(Collection<T> exprList, ILangExpression arg) throws CompilationException {
        for (ILangExpression langExpr : exprList) {
            if (!this.visit(langExpr, arg)) continue;
            return true;
        }
        return false;
    }

    private <T extends ILangExpression> boolean visitFieldList(Collection<Pair<T, Identifier>> fieldList, ILangExpression arg) throws CompilationException {
        for (Pair<T, Identifier> p : fieldList) {
            if (!this.visit((ILangExpression)p.first, arg)) continue;
            return true;
        }
        return false;
    }
}

