/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.logs;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class LogFile {
    private final File root;
    private long openTime;
    private PrintWriter out;

    public LogFile(File root) {
        this.root = root;
    }

    public void open() throws Exception {
        this.openTime = System.currentTimeMillis();
    }

    public synchronized void log(ObjectNode object) throws Exception {
        if (this.out == null) {
            this.root.mkdirs();
            this.out = new PrintWriter(new FileOutputStream(new File(this.root, this.openTime + ".log"), true));
        }
        this.out.println(object.asText());
        this.out.flush();
    }

    public synchronized void close() {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }
}

