/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.common.constraints;

import java.io.Serializable;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class AlgebricksCountPartitionConstraint
extends AlgebricksPartitionConstraint {
    private final int count;

    public AlgebricksCountPartitionConstraint(int count) {
        this.count = count;
    }

    @Override
    public AlgebricksPartitionConstraint.PartitionConstraintType getPartitionConstraintType() {
        return AlgebricksPartitionConstraint.PartitionConstraintType.COUNT;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return this.getPartitionConstraintType().toString() + ':' + this.count;
    }

    @Override
    public AlgebricksPartitionConstraint compose(AlgebricksPartitionConstraint that) throws AlgebricksException {
        switch (that.getPartitionConstraintType()) {
            case COUNT: {
                AlgebricksCountPartitionConstraint thatCount = (AlgebricksCountPartitionConstraint)that;
                return this.count <= thatCount.count ? this : that;
            }
            case ABSOLUTE: {
                return that.compose(this);
            }
        }
        throw AlgebricksException.create(10001, new Serializable[]{this.toString(), that.toString()});
    }
}

