/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.bitwise.AbstractBitSingleValueEvaluator;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

@MissingNullInOutFunction
public class BitCountDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = -6355679338952487274L;
    public static final IFunctionDescriptorFactory FACTORY = BitCountDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BIT_COUNT;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBitSingleValueEvaluator(ctx, args, BitCountDescriptor.this.getIdentifier(), BitCountDescriptor.this.sourceLoc){
                    private final AMutableInt32 resultMutableInt32;
                    private final ISerializerDeserializer aInt32Serde;
                    {
                        this.resultMutableInt32 = new AMutableInt32(0);
                        this.aInt32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    }

                    @Override
                    void applyBitwiseOperation(long value) {
                        this.resultMutableInt32.setValue(Long.bitCount(value));
                    }

                    @Override
                    void writeResult(IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.aInt32Serde.serialize((Object)this.resultMutableInt32, this.resultStorage.getDataOutput());
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

