/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.input.record.converter.CSVWithRecordConverterFactory;
import org.apache.asterix.external.input.record.converter.DCPConverterFactory;
import org.apache.asterix.external.input.record.converter.IRecordConverterFactory;

public class RecordConverterFactoryProvider {
    public static IRecordConverterFactory getConverterFactory(String format, String recordFormat) throws AsterixException {
        switch (recordFormat) {
            case "adm": 
            case "json": {
                switch (format) {
                    case "csv": 
                    case "delimited-text": {
                        return new CSVWithRecordConverterFactory();
                    }
                    case "dcp": {
                        return new DCPConverterFactory();
                    }
                }
            }
        }
        throw new AsterixException("Unknown Converter Factory that can convert from " + format + " to " + recordFormat);
    }
}

