/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io.profiling;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.control.nc.io.profiling.IOCounterCache;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOCounterIoStat
extends IOCounterCache<List<String>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String COMMAND = "iostat";
    private static final int PAGE_SIZE = 512;
    private long failureCount;
    private long baseReads = this.getReads();
    private long baseWrites = this.getWrites();

    IOCounterIoStat() {
    }

    @Override
    public long getReads() {
        try {
            long reads = this.extractColumn(4) * 512L;
            return reads == 0L ? -1L : reads - this.baseReads;
        }
        catch (Exception e) {
            LOGGER.log(this.failureCount++ > 0L ? Level.DEBUG : Level.WARN, "Failure getting reads", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public long getWrites() {
        try {
            long writes = this.extractColumn(5) * 512L;
            return writes == 0L ? -1L : writes - this.baseWrites;
        }
        catch (Exception e) {
            LOGGER.log(this.failureCount++ > 0L ? Level.DEBUG : Level.WARN, "Failure getting writes", (Throwable)e);
            return -1L;
        }
    }

    private long extractColumn(int columnIndex) throws IOException {
        boolean device = false;
        long ios = 0L;
        block0: for (String line : (List)this.getInfo()) {
            if (line.contains("Blk_read")) {
                device = true;
                continue;
            }
            if (!device) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String column = tokenizer.nextToken();
                if (i == columnIndex) {
                    ios += Long.parseLong(column);
                    continue block0;
                }
                ++i;
            }
        }
        return ios;
    }

    @Override
    protected List<String> calculateInfo() throws IOException {
        try (InputStream inputStream = Runtime.getRuntime().exec(COMMAND).getInputStream();){
            List list = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset());
            return list;
        }
    }
}

