/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.io;

import java.io.File;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.ManagedFileSplit;

public class MappedFileSplit
extends ManagedFileSplit {
    private static final long serialVersionUID = 1L;
    private final int ioDevice;
    private transient FileReference cached;

    public MappedFileSplit(String node, String path, int ioDevice) {
        super(node, path);
        this.ioDevice = ioDevice;
    }

    public int getIoDevice() {
        return this.ioDevice;
    }

    @Override
    public String toString() {
        return "Node: " + this.getNodeName() + " IO Device: " + this.ioDevice + " managed path: " + this.getPath();
    }

    @Override
    public File getFile(IIOManager ioManager) throws HyracksDataException {
        return this.getFileReference(ioManager).getFile();
    }

    @Override
    public FileReference getFileReference(IIOManager ioManager) throws HyracksDataException {
        if (this.cached == null) {
            this.cached = new FileReference(ioManager.getIODevices().get(this.ioDevice), this.getPath());
        }
        return this.cached;
    }
}

