/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.util.concurrent.TimeUnit;
import org.apache.asterix.app.function.ClientRequestsReader;
import org.apache.asterix.app.message.ClientRequestsRequest;
import org.apache.asterix.app.message.ClientRequestsResponse;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.metadata.declared.AbstractDatasourceFunction;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientRequestsFunction
extends AbstractDatasourceFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final ClientRequestsRequest.RequestType requestType;

    public ClientRequestsFunction(AlgebricksAbsolutePartitionConstraint locations, ClientRequestsRequest.RequestType requestType) {
        super(locations);
        this.requestType = requestType;
    }

    public IRecordReader<char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        INCServiceContext serviceCtx = ctx.getJobletContext().getServiceContext();
        INCMessageBroker messageBroker = (INCMessageBroker)serviceCtx.getMessageBroker();
        MessageFuture messageFuture = messageBroker.registerMessageFuture();
        long futureId = messageFuture.getFutureId();
        ClientRequestsRequest request = new ClientRequestsRequest(serviceCtx.getNodeId(), futureId, this.requestType);
        try {
            messageBroker.sendMessageToPrimaryCC((ICcAddressedMessage)request);
            ClientRequestsResponse response = (ClientRequestsResponse)messageFuture.get(ExecuteStatementRequestMessage.DEFAULT_NC_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            ClientRequestsReader clientRequestsReader = new ClientRequestsReader(response.getRequests());
            return clientRequestsReader;
        }
        catch (Exception e) {
            LOGGER.warn("Could not retrieve active requests", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            messageBroker.deregisterMessageFuture(futureId);
        }
    }
}

