/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.security;

import java.io.File;
import java.security.KeyStore;
import org.apache.hyracks.api.network.INetworkSecurityConfig;

public class NetworkSecurityConfig
implements INetworkSecurityConfig {
    private final boolean sslEnabled;
    private final File keyStoreFile;
    private final File trustStoreFile;
    private final String keyStorePassword;
    private final KeyStore keyStore;

    private NetworkSecurityConfig(boolean sslEnabled, String keyStoreFile, String keyStorePassword, String trustStoreFile, KeyStore keyStore) {
        this.sslEnabled = sslEnabled;
        this.keyStoreFile = keyStoreFile != null ? new File(keyStoreFile) : null;
        this.keyStorePassword = keyStorePassword;
        this.trustStoreFile = trustStoreFile != null ? new File(trustStoreFile) : null;
        this.keyStore = keyStore;
    }

    public static NetworkSecurityConfig of(boolean sslEnabled, String keyStoreFile, String keyStorePassword, String trustStoreFile) {
        return new NetworkSecurityConfig(sslEnabled, keyStoreFile, keyStorePassword, trustStoreFile, null);
    }

    public static NetworkSecurityConfig of(boolean sslEnabled, KeyStore keyStore, String keyStorePassword, String trustStoreFile) {
        return new NetworkSecurityConfig(sslEnabled, null, keyStorePassword, trustStoreFile, keyStore);
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }
}

