/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class EliminateIsomorphicSubplanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        Mutable assignInputOp;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan1 = (SubplanOperator)op1;
        Mutable op2Ref = (Mutable)subplan1.getInputs().get(0);
        ILogicalOperator op2 = (ILogicalOperator)op2Ref.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan2 = (SubplanOperator)op2;
        LinkedHashMap<LogicalVariable, LogicalVariable> assignVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        LinkedHashMap<LogicalVariable, LogicalVariable> tmpVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        ArrayList<LogicalVariable> tmpVarList = new ArrayList<LogicalVariable>();
        Iterator nestedPlanIter = subplan1.getNestedPlans().iterator();
        while (nestedPlanIter.hasNext()) {
            ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlanIter.next();
            Iterator rootOpIter = nestedPlan.getRoots().iterator();
            while (rootOpIter.hasNext()) {
                ILogicalOperator rootOp = (ILogicalOperator)((Mutable)rootOpIter.next()).getValue();
                if (!this.findIsomorphicPlanRoot(rootOp, subplan2, assignVarMap, tmpVarList, tmpVarMap)) continue;
                rootOpIter.remove();
            }
            if (!nestedPlan.getRoots().isEmpty()) continue;
            nestedPlanIter.remove();
        }
        int assignVarCount = assignVarMap.size();
        if (assignVarCount == 0) {
            return false;
        }
        ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>(assignVarCount);
        ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>(assignVarCount);
        for (Map.Entry entry : assignVarMap.entrySet()) {
            LogicalVariable subplan1Var = (LogicalVariable)entry.getKey();
            LogicalVariable subplan2Var = (LogicalVariable)entry.getValue();
            VariableReferenceExpression subplan2VarRef = new VariableReferenceExpression(subplan2Var);
            subplan2VarRef.setSourceLocation(subplan2.getSourceLocation());
            assignVars.add(subplan1Var);
            assignExprs.add(new MutableObject((Object)subplan2VarRef));
        }
        if (subplan1.getNestedPlans().isEmpty()) {
            assignInputOp = op2Ref;
        } else {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)subplan1);
            assignInputOp = new MutableObject((Object)subplan1);
        }
        AssignOperator assignOperator = new AssignOperator(assignVars, assignExprs);
        assignOperator.setSourceLocation(subplan1.getSourceLocation());
        assignOperator.getInputs().add(assignInputOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOperator);
        opRef.setValue((Object)assignOperator);
        return true;
    }

    private boolean findIsomorphicPlanRoot(ILogicalOperator op, SubplanOperator subplanOp, Map<LogicalVariable, LogicalVariable> outVarMap, List<LogicalVariable> tmpVarList, Map<LogicalVariable, LogicalVariable> tmpVarMap) throws AlgebricksException {
        for (ILogicalPlan nestedPlan : subplanOp.getNestedPlans()) {
            for (Mutable rootOpRef : nestedPlan.getRoots()) {
                ILogicalOperator rootOp = (ILogicalOperator)rootOpRef.getValue();
                if (!IsomorphismUtilities.isOperatorIsomorphicPlanSegment((ILogicalOperator)op, (ILogicalOperator)rootOp)) continue;
                tmpVarList.clear();
                VariableUtilities.getProducedVariables((ILogicalOperator)op, tmpVarList);
                tmpVarMap.clear();
                IsomorphismUtilities.mapVariablesTopDown((ILogicalOperator)rootOp, (ILogicalOperator)op, tmpVarMap);
                tmpVarMap.keySet().retainAll(tmpVarList);
                if (tmpVarMap.size() == tmpVarList.size()) {
                    outVarMap.putAll(tmpVarMap);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

