/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.kv.KeyValueEndpoint;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.service.AbstractPoolingService;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategies.PartitionSelectionStrategy;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;

public class KeyValueService
extends AbstractPoolingService {
    private static final SelectionStrategy STRATEGY = PartitionSelectionStrategy.INSTANCE;
    private static final Service.EndpointFactory FACTORY = new KeyValueEndpointFactory();

    public KeyValueService(String hostname, String bucket, String password, int port, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        super(hostname, bucket, password, port, env, env.kvEndpoints(), env.kvEndpoints(), STRATEGY, responseBuffer, FACTORY);
    }

    @Override
    public ServiceType type() {
        return ServiceType.BINARY;
    }

    static class KeyValueEndpointFactory
    implements Service.EndpointFactory {
        KeyValueEndpointFactory() {
        }

        @Override
        public Endpoint create(String hostname, String bucket, String password, int port, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
            return new KeyValueEndpoint(hostname, bucket, password, port, env, responseBuffer);
        }
    }
}

