/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.om.base.ADuration;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.marshalling.Integer64SerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;

public class ADurationSerializerDeserializer
implements ISerializerDeserializer<ADuration> {
    private static final long serialVersionUID = 1L;
    public static final ADurationSerializerDeserializer INSTANCE = new ADurationSerializerDeserializer();

    private ADurationSerializerDeserializer() {
    }

    public ADuration deserialize(DataInput in) throws HyracksDataException {
        int months = IntegerSerializerDeserializer.read((DataInput)in);
        long seconds = Integer64SerializerDeserializer.read((DataInput)in);
        return new ADuration(months, seconds);
    }

    public void serialize(ADuration instance, DataOutput out) throws HyracksDataException {
        IntegerSerializerDeserializer.write((int)instance.getMonths(), (DataOutput)out);
        Integer64SerializerDeserializer.write((long)instance.getMilliseconds(), (DataOutput)out);
    }

    public static int getYearMonth(byte[] data, int offset) {
        return AInt32SerializerDeserializer.getInt(data, offset + ADurationSerializerDeserializer.getYearMonthOffset());
    }

    public static long getDayTime(byte[] data, int offset) {
        return AInt64SerializerDeserializer.getLong(data, offset + ADurationSerializerDeserializer.getDayTimeOffset());
    }

    public static int getYearMonthOffset() {
        return 0;
    }

    public static int getDayTimeOffset() {
        return 4;
    }
}

