/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.visitor.AQLCloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.visitor.AbstractInlineUdfsVisitor;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class AQLInlineUdfsVisitor
extends AbstractInlineUdfsVisitor
implements IAQLVisitor<Boolean, List<FunctionDecl>> {
    public AQLInlineUdfsVisitor(LangRewritingContext context, IRewriterFactory rewriterFactory, List<FunctionDecl> declaredFunctions, MetadataProvider metadataProvider) {
        super(context, rewriterFactory, declaredFunctions, metadataProvider, (CloneAndSubstituteVariablesVisitor)new AQLCloneAndSubstituteVariablesVisitor(context));
    }

    @Override
    public Boolean visit(FLWOGRExpression flwor, List<FunctionDecl> arg) throws CompilationException {
        boolean changed = false;
        for (Clause c : flwor.getClauseList()) {
            if (!((Boolean)c.accept((ILangVisitor)this, arg)).booleanValue()) continue;
            changed = true;
        }
        Pair p = this.inlineUdfsInExpr(flwor.getReturnExpr(), arg);
        flwor.setReturnExpr((Expression)p.second);
        return changed || (Boolean)p.first != false;
    }

    @Override
    public Boolean visit(ForClause fc, List<FunctionDecl> arg) throws CompilationException {
        Pair p = this.inlineUdfsInExpr(fc.getInExpr(), arg);
        fc.setInExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(UnionExpr u, List<FunctionDecl> fds) throws CompilationException {
        Pair p = this.inlineUdfsInExprList(u.getExprs(), fds);
        u.setExprs((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(DistinctClause dc, List<FunctionDecl> arg) throws CompilationException {
        Pair p = this.inlineUdfsInExprList(dc.getDistinctByExpr(), arg);
        dc.setDistinctByExpr((List)p.second);
        return (Boolean)p.first;
    }

    public Boolean visit(ListSliceExpression expression, List<FunctionDecl> arg) throws CompilationException {
        return false;
    }

    protected Expression generateQueryExpression(List<LetClause> letClauses, Expression returnExpr) {
        ArrayList<Clause> letList = new ArrayList<Clause>();
        letList.addAll(letClauses);
        return new FLWOGRExpression(letList, returnExpr);
    }
}

